<?php
require_once "modelo.php";
require_once "AttachMailer.php";

class login extends Conectar
{
		
	public function nueva_sesion()
	{
		try{
			$usuario = mysqli_real_escape_string(Conectar::con(),$_POST['usu']);
			$clave = md5(mysqli_real_escape_string(Conectar::con(),$_POST['pass']));
			
			$conexion = Conectar::con();
			$estado=1;
			
			$sql = "SELECT a.id,a.id_perfil,a.estado,a.nombre,a.apepat,a.email,a.rut,b.roles FROM usuarios AS a LEFT JOIN perfiles as b ON a.id_perfil=b.id WHERE email=? AND clave=? AND estado=?;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ssi",$usuario,$clave,$estado);
			
			$sentencia->execute();
			$sentencia->store_result();
			$sentencia->bind_result($id, $id_perfil,$estado,$nombre,$apepat,$email,$rut,$roles);
			$sentencia->fetch();	
			//$result = $sentencia->get_result();
			
			if ($sentencia->num_rows > 0) {
				$conexion->close();
                $sentencia->close();
				
				session_start();
				$_SESSION["autentificado"]= "SI";
				$_SESSION['usuario_id'] = $id;
				$_SESSION['id_perfil'] = $id_perfil;
				$_SESSION['estado'] = $estado;
				$_SESSION['nombre'] = $nombre;
				$_SESSION['apepat'] = $apepat;
				$_SESSION['email'] = $email;
				$_SESSION['rut'] = $rut;
				$_SESSION['roles'] = $roles;
				$_SESSION['f_actualizacion'] = $f_actualizacion;
				$_SESSION["ultimoAcceso"]= date("Y-n-j H:i:s");
				$_SESSION['id_paciente'] = "";
				$_SESSION['id_paciente_carga'] = "";
				
				//$fch= fopen("fichero.txt", "a"); // Abres el archivo para escribir en él
					//fwrite($fch, $_SESSION['id_paciente_carga']); // Grabas
				//fclose($fch); // Cierras el archivo.

				header("Location:vistas/inicio.php");
			
			}else{
				$conexion->close();
                $sentencia->close();
                header("Location:index.php?usuario=usuario_no_existe");
			}
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function caduca_session($auntentificado,$ultimoAcceso){
		if ($auntentificado != "SI") {
			session_destroy();
			echo'<script language="javascript">window.location="/index.php"</script>;';
			//header("Location:/index.php");
		} else {
			//sino, calculamos el tiempo transcurrido
			$fechaGuardada = $ultimoAcceso;
			$ahora = date("Y-n-j H:i:s");
			$tiempo_transcurrido = (strtotime($ahora)-strtotime($fechaGuardada));

			//comparamos el tiempo transcurrido
			 if($tiempo_transcurrido >= 18000) {
			 //si pasaron 5 horas o más    18000
			  session_destroy();
			  header("Location: index.php");
			}else {
			$_SESSION["ultimoAcceso"] = $ahora;
		   }
		}
	}
	
	public function salir(){
		session_destroy();
		header("Location: /index.php");
	}
	
	public function registro($email){	
		try{
			$conexion = Conectar::con();
			
			$sql = "SELECT * FROM usuarios WHERE email=?;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("s",$email);			
			$sentencia->execute();
			$sentencia->store_result();
			
			
			if ($sentencia->num_rows > 0) {
				$conexion->close();
                $sentencia->close();
				return "1";
			}else{
				$conexion->close();
                $sentencia->close();
                return "0";
			}
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
			
	}
	
	public function registro_nom($nombre_usuario){
			$query = "SELECT * FROM usuarios WHERE usuario='".$nombre_usuario."';";
			$resultado = mysqli_query(Conectar::con(),$query);
			$check_user = mysqli_num_rows($resultado);
			
			if($check_user>0){
				return "1";
			}
			else {
				return "0";
			}
			
	}
	
	public function activaUsuario($email,$token)
	{
		try{
			$conexion = Conectar::con();
			$sql = "select id from usuarios where email=? AND cod_verifica=? LIMIT 1;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ss",$email,$token);
			$sentencia->execute();
			$sentencia->bind_result($id);

			while ($sentencia->fetch()) {
				
				$estado=1;
				$conexion2 = Conectar::con();
				$sql2 = "UPDATE usuarios set estado=? WHERE id=?;";
				$sentencia2 = $conexion2->prepare($sql2);
				$sentencia2->bind_param("ii",$estado,$id);
				$sentencia2->execute();
				
				if ($sentencia2->errno) {
					header("Location:index.php?usuario=errordeactivacion");
				}else {
					header("Location:index.php?usuario=usuarioactivado");
				}
				$conexion2->close();
				$sentencia2->close();
			}
			
			$conexion->close();
            $sentencia->close();
			
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function crearUsuario($email,$clave,$titulo,$nombre,$apepat,$apemat,$nombre_usuario,$fonomovil,$fonofijo,$nombre_clinica,$direccion,$region,$provincia,$comuna,$fono,$sitioweb){
		$genero="M";
		if($titulo=="Dra" || $titulo=="Sra" || $titulo=="Srta" ){
			$genero="F";
		}
		$pass = md5($clave);
		
		try{

            $conexion = Conectar::con();
            $sql = "INSERT INTO usuarios VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			$null = null;
			$id_perfil = 2;// ver con cristian
			$estado = 1;//activo
			$fcreacion = date('Y-m-d H:i:s');
			$factualizacion = date('Y-m-d H:i:s');
			
            $sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("iiiisssssssssssssiis",$null,$id_perfil,$estado,$null,$fcreacion,$factualizacion,$nombre,$apepat,$apemat,$nombre_usuario,$pass,$email,$genero,$null,$null,$null,$null,$null,$null,$null);

			
			
            if($sentencia->execute()){
				$id_usuario =$conexion->insert_id;
				$sentencia->close();
				
					$sql2 = "INSERT INTO clinicas VALUES (?,?,?,?,?,?,?,?,?)";
					$sentencia2 = $conexion->prepare($sql2);
					$sentencia2->bind_param("iissiiiss",$null,$id_usuario,$nombre_clinica,$direccion,$region,$provincia,$comuna,$fono,$sitioweb);
					 if($sentencia2->execute()){
						$conexion->close();
						$sentencia2->close();
						header("Location:registro_completado.php");
						
						return true;
					 }else{
						$conexion->close();
						$sentencia2->close();
						echo "Error en la insercion clinica.";
					 }

            }
            else{
                $conexion->close();
                $sentencia->close();
                echo "Error en la insercion usuario.";
            }
        }catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function recuperarContra($email){
		try{
			$claveran = rand(1999, 9999);
			$clave = md5($claveran);
		
			$conexion = Conectar::con();
			$estado=0;
			$sql = "UPDATE usuarios set clave=? WHERE email=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ss",$clave,$email);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				echo "fallo!!! " . $sentencia->error;
			}else {
				if($sentencia->affected_rows>0){
					//Enviar correo de verificacion para el usuario
					$para = $email;
					$titulo = 'Recuperar contraseña Sistema I-Travel';
					$mensaje='<html>';
					$mensaje .='<head><title>I-Travel</title></head>';
					$mensaje .='<body>';
					$mensaje .='<b>Estimado(a)</b><br>';
					$mensaje .='Su clave ha sido reestablecida.<br>';
					$mensaje .='Su nueva clave es :<br>';
					$mensaje .= '<h3>'.$claveran.'</h3>';
					$mensaje .='Si desea modificarla debe ingresar al panel de configuración dentro del sistema.<br> ';
					$mensaje .='Atentamente, <br>Equipo I-Travel<br></body>';
					
					$cabeceras  = 'MIME-Version: 1.0' . "\r\n";
					$cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
					$cabeceras .= 'From: I-Travel <contactoADM@i-travel.com>' . "\r\n";
					
					mail($para, $titulo, $mensaje, $cabeceras);
					
					header("Location:index.php");
				}
			}

			$conexion->close();
            $sentencia->close();
			
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
}
?>