<?php
require_once "config.php";
require_once "AttachMailer.php";
	
class Conectar
{
	public static function con()
	{
		//phpinfo();
		
		$conexion = new mysqli(HOST,USER,PASS,DBNAME);
		$conexion->set_charset("utf8");
		
        if($conexion->connect_error){
            die("Error en la conexion : ".$conexion->connect_errno.
                                      "-".$conexion->connect_error);
        }
		
        return $conexion;
	}
}

class evaluacion extends Conectar{
	public function getEva($id_prov)
	{
		try{
			$conexion = Conectar::con();
			//$sql = "SELECT id,nombre FROM eva_categorias ORDER BY id ASC;";
			
			
			
			$sql = "SELECT";
			$sql .=" a.id,a.fecha_hora,b.nombre,b.apepat,c.prom_servicio,d.prom_producto,e.prom_comercial,f.prom_sugerencias";
			$sql .=" FROM eva_evaluaciones as a";
			$sql .=" LEFT JOIN usuarios as b ON a.id_us_crea=b.id";
			$sql .=" LEFT JOIN (";
			$sql .=" SELECT (sum(a.respuesta)/count(a.respuesta)) as prom_servicio,a.id_eva FROM eva_respuestas as a LEFT JOIN eva_preguntas as b on a.id_pregunta=b.id LEFT JOIN eva_categorias as c on b.id_cat=c.id WHERE c.nombre='SERVICIO' AND a.respuesta!='NO APLICA' GROUP BY a.id_eva";
			$sql .=") as c ON c.id_eva=a.id";
			$sql .=" LEFT JOIN (";
			$sql .=" SELECT (sum(a.respuesta)/count(a.respuesta)) as prom_producto,a.id_eva FROM eva_respuestas as a LEFT JOIN eva_preguntas as b on a.id_pregunta=b.id LEFT JOIN eva_categorias as c on b.id_cat=c.id WHERE c.nombre='PRODUCTO' AND a.respuesta!='NO APLICA' GROUP BY a.id_eva";
			$sql .=") as d ON d.id_eva=a.id";
			$sql .=" LEFT JOIN (";
			$sql .=" SELECT (sum(a.respuesta)/count(a.respuesta)) as prom_comercial,a.id_eva FROM eva_respuestas as a LEFT JOIN eva_preguntas as b on a.id_pregunta=b.id LEFT JOIN eva_categorias as c on b.id_cat=c.id WHERE c.nombre='COMERCIAL' AND a.respuesta!='NO APLICA' GROUP BY a.id_eva";
			$sql .=") as e ON e.id_eva=a.id";
			$sql .=" LEFT JOIN (";
			$sql .=" SELECT (sum(a.respuesta)/count(a.respuesta)) as prom_sugerencias,a.id_eva FROM eva_respuestas as a LEFT JOIN eva_preguntas as b on a.id_pregunta=b.id LEFT JOIN eva_categorias as c on b.id_cat=c.id WHERE c.nombre='SUGERENCIAS' AND a.respuesta!='NO APLICA' GROUP BY a.id_eva";
			$sql .=") as f ON f.id_eva=a.id";
			$sql .=" WHERE a.id_prov=? ORDER BY a.id DESC;";

			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id_prov);
			$sentencia->execute();

			
			
			$sentencia->bind_result($id,$fecha_hora,$nombre,$apepat,$servicio,$producto,$comercial,$sugerencias);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch()) {
				 $arr[$i]['id']=$id;
				 $arr[$i]['fecha_hora']=$fecha_hora;
				 $arr[$i]['nombre']=$nombre;
				 $arr[$i]['apepat']=$apepat;
				 $arr[$i]['servicio']=$servicio;
				 $arr[$i]['producto']=$producto;
				 $arr[$i]['comercial']=$comercial;
				 $arr[$i]['sugerencias']=$sugerencias;
				 $i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function getEvaCategorias()
	{
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,nombre FROM eva_categorias ORDER BY id ASC;";
			$sentencia = $conexion->prepare($sql);
			//$sentencia->bind_param("i",$id);
			$sentencia->execute();

			$sentencia->bind_result($id,$nombre);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch()) {
				 $arr[$i]['id']=$id;
				 $arr[$i]['nombre']=$nombre;
				 $i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function getEvapreguntas($id)
	{
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,pregunta FROM eva_preguntas WHERE id_cat=? ORDER BY id ASC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();

			$sentencia->bind_result($id,$pregunta);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch()) {
				 $arr[$i]['id']=$id;
				 $arr[$i]['pregunta']=$pregunta;
				 $i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function creaEva($id_us,$id_prov,$arr_respuestas)
	{
		try{
			
			$conexion = Conectar::con();
			$fecha_hora = date('Y-m-j H:i:s');
			$sql = "INSERT INTO eva_evaluaciones(fecha_hora,id_us_crea,id_prov) VALUES(?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("sii",$fecha_hora,$id_us,$id_prov);
			$sentencia->execute();
			$id_eva='';
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				$id_eva=$conexion->insert_id;
				for($i=0;$i<count($arr_respuestas);$i++){
					$sql = "INSERT INTO eva_respuestas(id_eva,id_pregunta,respuesta) VALUES(?,?,?);";
					$sentencia = $conexion->prepare($sql);
					$sentencia->bind_param("iis",$id_eva,$arr_respuestas[$i][0],$arr_respuestas[$i][1]);
					$sentencia->execute();
				}
				
				
			}
			
			$conexion->close();
			$sentencia->close();
			
			return 1;
			
			
			//return $arr_respuestas[0][1];
			
			
			//count($arr_respuestas);
			
			
			/*$conexion = Conectar::con();
			$fecha_hora = date('Y-m-j H:i:s');
			$sql = "INSERT INTO eva_evaluaciones(fecha_hora,id_us_crea,id_prov) VALUES(?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("sii",$fecha_hora,$id_us,$id_prov);
			$sentencia->execute();

			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;
			}*/
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function creaEvaPreg($id_eva,$id_pre,$valor_pre)
	{
		try{
			$conexion = Conectar::con();
			$sql = "INSERT INTO eva_respuestas(id_eva,id_pregunta,respuesta) VALUES(?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("iis",$id_eva,$id_pre,$valor_pre);
			$sentencia->execute();

			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;
			}
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
}








	
class voucher extends Conectar{
	public function getDatosVou($id)
	{
		try{
			$conexion = Conectar::con();
			$sql = "SELECT a.id,a.nombre,a.rut,c.Pais,d.Ciudad,a.direccion,a.fono1,a.num_f_emergencia FROM proveedores as a LEFT JOIN servicios_negocios as b ON b.id_proveedor=a.id LEFT JOIN paises as c ON a.pais=c.Codigo LEFT JOIN ciudades as d ON a.ciudad=d.idCiudades WHERE b.id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();

			$sentencia->bind_result($id,$nombre,$rut,$pais,$ciudad,$direccion,$fono,$femerg);
			$arr = array();
			 while ($sentencia->fetch()) {
				 $arr['id']=$id;
				 $arr['nombre']=$nombre;
				 $arr['rut']=$rut;
				 $arr['pais']=$pais;
				 $arr['ciudad']=$ciudad;
				 $arr['direccion']=$direccion;
				 $arr['fono']=$fono;
				 $arr['femerg']=$femerg;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}


	public function insertVou($datos)
	{
		try{
			$conexion = Conectar::con();
			$fecha = date('Y-m-j');
			$sql = "INSERT INTO voucher(id_negocio,f_crea,f_act,us_crea,us_act,n_pasajero,tipo_voucher,nombre_proveedor,direccion,fono1,fonoe,nombre_pasa,doc_ident,detalle,n_aloj,desde_aloj,hasta_aloj,trans_in,l_aerea_in,n_vuelo_in,hora_in,trans_out,l_aerea_out,n_vuelo_out,hora_out,serv_fecha,serv_hora,pais,ciudad) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("issssssssssssssssssssssssssss",$datos['id_negocio'],$fecha,$fecha,$datos['us_crea'],$datos['us_act'],$datos['n_pasajero'],$datos['tipo_voucher'],$datos['nombre_proveedor'],$datos['direccion'],$datos['fono1'],$datos['fonoe'],$datos['nombre_pasa'],$datos['doc_ident'],$datos['detalle'],$datos['n_aloj'],$datos['desde_aloj'],$datos['hasta_aloj'],$datos['trans_in'],$datos['l_aerea_in'],$datos['n_vuelo_in'],$datos['hora_in'],$datos['trans_out'],$datos['l_aerea_out'],$datos['n_vuelo_out'],$datos['hora_out'],$datos['serv_fecha'],$datos['serv_hora'],$datos['pais'],$datos['ciudad']);
			$sentencia->execute();

			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;
			}
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}

	public function GetVouchers($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,id_negocio,f_crea,f_act,us_crea,us_act,n_pasajero,tipo_voucher,nombre_proveedor,nombre_pasa,detalle FROM voucher WHERE id_negocio=? ORDER BY id DESC";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();

			$sentencia->bind_result($id,$id_negocio,$f_crea,$f_act,$us_crea,$us_act,$n_pasajero,$tipo_voucher,$nombre_proveedor,$nombre_pasa,$detalle);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch()) {
				 $arr[$i]['id']=$id;
				 $arr[$i]['id_negocio']=$id_negocio;
				 $arr[$i]['f_crea']=$f_crea;
				 $arr[$i]['f_act']=$f_act;
				 $arr[$i]['us_crea']=$us_crea;
				 $arr[$i]['us_act']=$us_act;
				 $arr[$i]['n_pasajero']=$n_pasajero;
				 $arr[$i]['tipo_voucher']=$tipo_voucher;
				 $arr[$i]['nombre_proveedor']=$nombre_proveedor;
				 $arr[$i]['nombre_pasa']=$nombre_pasa;
				 $arr[$i]['detalle']=$detalle;			 
				$i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
		
		
	
	}	
	
	public function borrarVou($id){
		try{
			$sql = "DELETE FROM voucher WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function getVou($id)
	{
		try{
			$conexion = Conectar::con();
			$sql = "SELECT pais,ciudad,id,id_negocio,f_crea,f_act,us_crea,us_act,n_pasajero,tipo_voucher,nombre_proveedor,direccion,fono1,fonoe,nombre_pasa,doc_ident,detalle,n_aloj,desde_aloj,hasta_aloj,trans_in,l_aerea_in,n_vuelo_in,hora_in,trans_out,l_aerea_out,n_vuelo_out,hora_out,serv_fecha,serv_hora FROM voucher WHERE id=? LIMIT 1;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$sentencia->bind_result($pais,$ciudad,$id,$id_negocio,$f_crea,$f_act,$us_crea,$us_act,$n_pasajero,$tipo_voucher,$nombre_proveedor,$direccion,$fono1,$fonoe,$nombre_pasa,$doc_ident,$detalle,$n_aloj,$desde_aloj,$hasta_aloj,$trans_in,$l_aerea_in,$n_vuelo_in,$hora_in,$trans_out,$l_aerea_out,$n_vuelo_out,$hora_out,$serv_fecha,$serv_hora);
			$arr = array();
			 while ($sentencia->fetch()) {
				$arr['id']=$id;
				$arr['id_negocio']=$id_negocio;
				$arr['f_crea']=$f_crea;
				$arr['f_act']=$f_act;
				$arr['us_crea']=$us_crea;
				$arr['us_act']=$us_act;
				$arr['n_pasajero']=$n_pasajero;
				$arr['tipo_voucher']=$tipo_voucher;
				$arr['nombre_proveedor']=$nombre_proveedor;
				$arr['direccion']=$direccion;
				$arr['pais']=$pais;
				$arr['ciudad']=$ciudad;
				$arr['fono1']=$fono1;
				$arr['fonoe']=$fonoe;
				$arr['nombre_pasa']=$nombre_pasa;
				$arr['doc_ident']=$doc_ident;
				$arr['detalle']=$detalle;
				$arr['n_aloj']=$n_aloj;
				$arr['desde_aloj']=$desde_aloj;
				$arr['hasta_aloj']=$hasta_aloj;
				$arr['trans_in']=$trans_in;
				$arr['l_aerea_in']=$l_aerea_in;
				$arr['n_vuelo_in']=$n_vuelo_in;
				$arr['hora_in']=$hora_in;
				$arr['trans_out']=$trans_out;
				$arr['l_aerea_out']=$l_aerea_out;
				$arr['n_vuelo_out']=$n_vuelo_out;
				$arr['hora_out']=$hora_out;
				$arr['serv_fecha']=$serv_fecha;
				$arr['serv_hora']=$serv_hora;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function updateVou($datos)
	{
		try{
			$conexion = Conectar::con();
			$fecha = date('Y-m-j');
			$sql = "UPDATE voucher SET pais=?,ciudad=?,f_act=?,us_act=?,n_pasajero=?,tipo_voucher=?,nombre_proveedor=?,direccion=?,fono1=?,fonoe=?,nombre_pasa=?,doc_ident=?,detalle=?,n_aloj=?,desde_aloj=?,hasta_aloj=?,trans_in=?,l_aerea_in=?,n_vuelo_in=?,hora_in=?,trans_out=?,l_aerea_out=?,n_vuelo_out=?,hora_out=?,serv_fecha=?,serv_hora=? WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ssssssssssssssssssssssssssi",$datos['pais'],$datos['ciudad'],$fecha,$datos['us_act'],$datos['n_pasajero'],$datos['tipo_voucher'],$datos['nombre_proveedor'],$datos['direccion'],$datos['fono1'],$datos['fonoe'],$datos['nombre_pasa'],$datos['doc_ident'],$datos['detalle'],$datos['n_aloj'],$datos['desde_aloj'],$datos['hasta_aloj'],$datos['trans_in'],$datos['l_aerea_in'],$datos['n_vuelo_in'],$datos['hora_in'],$datos['trans_out'],$datos['l_aerea_out'],$datos['n_vuelo_out'],$datos['hora_out'],$datos['serv_fecha'],$datos['serv_hora'],$datos['id_voucher']);
			$sentencia->execute();

			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;
			}
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	
	
	public function getProvVou($id)
	{
		try{
			$conexion = Conectar::con();
			$sql = "SELECT b.nombre FROM servicios_negocios as a LEFT JOIN proveedores as b ON a.id_proveedor=b.id WHERE a.id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$sentencia->bind_result($nombre);
			$nombre = '';
			 while ($sentencia->fetch()) {
				$nombre=$nombre;
			}

			$conexion->close();
			$sentencia->close();
			return $nombre;
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	
	
	
}

























class general extends Conectar{
	public function getComprobanteAllCl($ids,$tabla)
	{
		try{
			$query='a.id=';
			if(count($ids)>1){
				for($i=0;$i<count($ids);$i++){
					if(count($ids)==($i+1)){
						$query=$query.$ids[$i];
					}else{
						$query=$query.$ids[$i].' OR a.id=';
					}
				}
			}else{
				$query=$query.$ids[0];
			}
			
			$conexion = Conectar::con();
			$sql = "SELECT d.id,a.f_deposito,a.id,a.id_negocio,a.id_us_crea,a.fecha,a.monto,a.forma_pago,a.n_cheque,a.n_cuotas,a.cargo_transbank,a.total_cuota,a.tipo_moneda,b.nombre,b.apepat,b.rut,a.detalle,c.nombre_pasa_pri,c.rut_pasa_pri FROM pagos_negocio_cli as a LEFT JOIN usuarios as b ON a.id_us_crea=b.id LEFT JOIN negocios as c ON a.id_negocio=c.id LEFT JOIN comprobantes as d ON a.id=d.id_tabla WHERE d.tabla='".$tabla."' AND (".$query.") ORDER BY a.id ASC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($id_folio,$f_deposito,$id,$id_negocio,$id_us_crea,$fecha,$monto,$forma_pago,$n_cheque,$n_cuotas,$cargo_transbank,$total_cuota,$tipo_moneda,$nombre,$apepat,$rut,$detalle,$nombre_pasa_pri,$rut_pasa_pri);
			
			
			
			
			
			
			
			$arr = array();
			$i=0; 
			 while ($sentencia->fetch()) {
				 $arr[$i]['id_folio']=$id_folio;
				 $arr[$i]['f_deposito']=$f_deposito;
				 $arr[$i]['id']=$id;
				 $arr[$i]['id_negocio']=$id_negocio;
				 $arr[$i]['id_us_crea']=$id_us_crea;
				 $arr[$i]['fecha']=$fecha;
				 $arr[$i]['monto']=$monto;
				 $arr[$i]['forma_pago']=$forma_pago;
				 $arr[$i]['n_cheque']=$n_cheque;
				 $arr[$i]['n_cuotas']=$n_cuotas;
				 $arr[$i]['cargo_transbank']=$cargo_transbank;
				 $arr[$i]['total_cuota']=$total_cuota;
				 $arr[$i]['tipo_moneda']=$tipo_moneda;
				 $arr[$i]['nombre']=$nombre;
				 $arr[$i]['apepat']=$apepat;
				 $arr[$i]['rut']=$rut;
				 $arr[$i]['detalle']=$detalle;
				 $arr[$i]['nombre_pasa_pri']=$nombre_pasa_pri;
				 $arr[$i]['rut_pasa_pri']=$rut_pasa_pri;
				$i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
			
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }		
		
	}
	
	
	public function getComprobante($tipo,$id_tabla,$tabla)
	{
		try{
			$conexion = Conectar::con();			
			$sql = "SELECT id FROM comprobantes WHERE id_tabla=? AND tabla=?;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("is",$id_tabla,$tabla);
			$sentencia->execute();
			$sentencia->bind_result($id);
			$sentencia->store_result();
			
			$folio='';
			
			if($sentencia->num_rows>0){
				while ($sentencia->fetch()) {
					$folio=$id;
				}
			}else{
				$conexion = Conectar::con();
				$sql = "INSERT INTO comprobantes(tipo,id_tabla,tabla) VALUES(?,?,?);";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("sis",$tipo,$id_tabla,$tabla);
				$sentencia->execute();

				if ($sentencia->errno) {
					return "fallo!!! " . $sentencia->error;
				}else {
					$folio=$conexion->insert_id;
				}
			}
			
			
			if($tabla=='pagos_negocio_cli'){
				$conexion = Conectar::con();
				$sql = "SELECT a.f_deposito,a.id,a.id_negocio,a.id_us_crea,a.fecha,a.monto,a.forma_pago,a.n_cheque,a.n_cuotas,a.cargo_transbank,a.total_cuota,a.tipo_moneda,b.nombre,b.apepat,b.rut,a.detalle,c.nombre_pasa_pri,c.rut_pasa_pri FROM pagos_negocio_cli as a LEFT JOIN usuarios as b ON a.id_us_crea=b.id LEFT JOIN negocios as c ON a.id_negocio=c.id WHERE a.id=?;";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("i",$id_tabla);	
				$sentencia->execute();
				
				$sentencia->bind_result($f_deposito,$id,$id_negocio,$id_us_crea,$fecha,$monto,$forma_pago,$n_cheque,$n_cuotas,$cargo_transbank,$total_cuota,$tipo_moneda,$nombre,$apepat,$rut,$detalle,$nombre_pasa_pri,$rut_pasa_pri);
				$arr = array();
				
				 while ($sentencia->fetch())
				 {
					 $arr['folio']=$folio;
					 $arr['id']=$id;
					 $arr['id_negocio']=$id_negocio;
					 $arr['id_us_crea']=$id_us_crea;
					 $arr['fecha']=$fecha;
					 $arr['monto']=$monto;
					 $arr['forma_pago']=$forma_pago;
					 $arr['n_cheque']=$n_cheque;
					 $arr['n_cuotas']=$n_cuotas;
					 $arr['cargo_transbank']=$cargo_transbank;
					 $arr['total_cuota']=$total_cuota;
					 $arr['tipo_moneda']=$tipo_moneda;
					 $arr['nombre']=$nombre;
					 $arr['apepat']=$apepat;
					 $arr['rut']=$rut;
					 $arr['detalle']=$detalle;
					 $arr['nombre_pasa_pri']=$nombre_pasa_pri;
					 $arr['rut_pasa_pri']=$rut_pasa_pri;
					 $arr['f_deposito']=$f_deposito;
					 
				}
				return $arr;
			}
				
			if($tabla=='pagos_serv'){
				$conexion = Conectar::con();
				$sql = "SELECT c.fecha_pago,c.descripcion,a.n_cheque,c.id_negocio,a.fecha_pago,a.id,a.id_servicio,b.nombre,b.apepat,b.rut,a.fecha,a.monto,c.valor_tipo_cambio,a.detalle,a.tipo_moneda,a.forma_pago,a.detalleefe,d.nombre FROM pagos_serv as a LEFT JOIN usuarios as b on a.id_us_crea=b.id LEFT JOIN servicios_negocios as  c ON a.id_servicio=c.id LEFT JOIN proveedores as d ON d.id=c.id_proveedor WHERE a.id=?;";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("i",$id_tabla);	
				$sentencia->execute();

				$sentencia->bind_result($fecha_pago_pago,$descripcionpago,$n_cheque,$id_negocio,$fecha_pago,$id,$id_servicio,$nombre,$apepat,$rut,$fecha,$monto,$valor_tipo_cambio,$detalle,$tipo_moneda,$forma_pago,$detalleefe,$proveedor);
				$arr = array();
				 while ($sentencia->fetch())
				 {
					$arr['folio']=$folio;	
					$arr['id_negocio']=$id_negocio;
					$arr['fecha_pago']=$fecha_pago;
					$arr['id']=$id;
					$arr['n_cheque']=$n_cheque;
					$arr['id_servicio']=$id_servicio;
					$arr['nombre']=$nombre;
					$arr['apepat']=$apepat;
					$arr['rut']=$rut;
					$arr['fecha']=$fecha;
					$arr['monto']=$monto;
					$arr['valor_tipo_cambio']=$valor_tipo_cambio;
					$arr['detalle']=$detalle;
					$arr['tipo_moneda']=$tipo_moneda;
					$arr['forma_pago']=$forma_pago;
					$arr['detalleefe']=$detalleefe;
					$arr['proveedor']=$proveedor;
					$arr['fecha_pago_pago']=$fecha_pago_pago;
					$arr['descripcionpago']=$descripcionpago;
				}
				return $arr;
				
			}
			
			if($tabla=='gastos'){
				$conexion = Conectar::con();
				$sql = "SELECT detalleefe,id,f_crea,f_ingreso,tipo,monto,n_cheque,id_cheque,forma_pago,razon,empresa,f_ingreso FROM gastos WHERE id=?;";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("i",$id_tabla);
				$sentencia->execute();
				
				$sentencia->bind_result($detalleefe,$id,$f_crea,$mes_gasto,$tipo,$monto,$n_cheque,$id_cheque,$forma_pago,$razon,$empresa,$f_ingreso);
				$arr = array();
				 while ($sentencia->fetch()) {
					$arr['folio']=$folio;	 
					$arr['id']=$id;
					$arr['f_crea']=$f_crea;
					$arr['mes_gasto']=$mes_gasto;
					$arr['tipo']=$tipo;
					$arr['monto']=$monto;
					$arr['id_cheque']=$id_cheque;
					$arr['n_cheque']=$n_cheque;
					$arr['forma_pago']=$forma_pago;
					$arr['razon']=$razon;
					$arr['empresa']=$empresa;
					$arr['f_ingreso']=$f_ingreso;
					$arr['detalleefe']=$detalleefe;
				}
				return $arr;
			}
 

			$conexion->close();
            $sentencia->close();
			//return $arr;
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
		
	}
	
	public function getcliente($rut)
	{
		try{
			$conexion = Conectar::con();
			if($rut != ""){
				$sql = "SELECT id,rut,nombre,apepat,apemat,tipo_cliente FROM clientes where rut=?"; 
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("s",$rut);
			}else{
				$sql = "SELECT id,rut,nombre,apepat,apemat,tipo_cliente FROM clientes"; 
				$sentencia = $conexion->prepare($sql);
			}
			
			$sentencia->execute();
			
			$sentencia->bind_result($id,$rut,$nombre,$apepat,$apemat,$tipo_cliente);
			$arr = array();
			$i=0;
			
			 while ($sentencia->fetch()) {
				 $arr[$i]['id']=$id;
				 $arr[$i]['rut']=$rut;
				 $arr[$i]['nombre']=$nombre;
				 $arr[$i]['apepat']= $apepat;
				 $arr[$i]['apemat']=$apemat;
				 $arr[$i]['tipo_cliente']=$tipo_cliente; 
				 $i++;
			}

			$conexion->close();
            $sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	
	}
	
	public function getclienteNom($nombre)
	{
		try{
			$conexion = Conectar::con();
			if($nombre != ""){
				$sql = "SELECT id,rut,nombre,apepat,apemat,tipo_cliente FROM clientes where nombre LIKE '".$nombre."%'"; 
				$sentencia = $conexion->prepare($sql);
				//$sentencia->bind_param("s",$nombre);
			}else{
				$sql = "SELECT id,rut,nombre,apepat,apemat,tipo_cliente FROM clientes"; 
				$sentencia = $conexion->prepare($sql);
			}
			
			$sentencia->execute();
			
			$sentencia->bind_result($id,$rut,$nombre,$apepat,$apemat,$tipo_cliente);
			$arr = array();
			$i=0;
			
			 while ($sentencia->fetch()) {
				 $arr[$i]['id']=$id;
				 $arr[$i]['rut']=$rut;
				 $arr[$i]['nombre']=$nombre;
				 $arr[$i]['apepat']= $apepat;
				 $arr[$i]['apemat']=$apemat;
				 $arr[$i]['tipo_cliente']=$tipo_cliente;
				 $i++;
			}

			$conexion->close();
            $sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	
	}

	public function getPaises(){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT Codigo,Pais FROM paises ORDER BY Pais ASC;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			
			$sentencia->bind_result($Codigo,$Pais);
			$arr = array();
			$i=0; 
			 while ($sentencia->fetch()) {
				$arr[$i]['codigo']=$Codigo;
				$arr[$i]['pais']=$Pais;
				$i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function getCiudades($codigo){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT idCiudades,Paises_Codigo,Ciudad FROM ciudades where Paises_Codigo=? ORDER BY Ciudad ASC"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("s",$codigo);
			$sentencia->execute();
			
			$sentencia->bind_result($idCiudades,$Paises_Codigo,$Ciudad);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch()) {
				$arr[$i]['id_ciudad']=$idCiudades;
				$arr[$i]['pais_codigo']=$Paises_Codigo;
				$arr[$i]['ciudad']=$Ciudad;
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
}

class proveedores extends Conectar{
	public function getServiciosPagosFiltroPagPROV($id_prov,$nombre,$nombre2,$fechab,$tipo){
		try{
			$conexion = Conectar::con();
			$registros_porp = 10;			
			$buscar='';
			
			if($nombre!=''){$buscar=$buscar."(cc.nombre LIKE '%".$nombre."%' OR cc.apepat LIKE '%".$nombre."%') AND ";}
			if($nombre2!=''){$buscar=$buscar."b.nombre_pasa_pri LIKE '%".$nombre2."%' AND ";}
			if($fechab!=''){$buscar=$buscar."a.fecha_pago='".$fechab."' AND ";}
			if($id_prov!=''){$buscar=$buscar."c.id=".$id_prov." AND ";}
			
			$fecha = date('Y-m-j');
			$nuevafecha = strtotime ( '+7 day' , strtotime ( $fecha ) ) ;
			$nuevafecha = date ( 'Y-m-j' , $nuevafecha );
			
			if($tipo=='pendientes'){
				$sql = "SELECT CONCAT(cc.nombre,' ',cc.apepat) as cliente,b.nombre_pasa_pri,a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND (f.pago_servicios is null OR f.pago_servicios='') GROUP BY a.id ORDER BY a.id DESC;";	
			}
			
			if($tipo=='incompletos'){
				$sql = "SELECT CONCAT(cc.nombre,' ',cc.apepat) as cliente,b.nombre_pasa_pri,a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  f.pago_servicios<e.valor_servicios GROUP BY a.id ORDER BY a.id DESC;";	
			}
			
			if($tipo=='pagados'){
				$sql = "SELECT CONCAT(cc.nombre,' ',cc.apepat) as cliente,b.nombre_pasa_pri,a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  f.pago_servicios>=e.valor_servicios GROUP BY a.id ORDER BY a.id DESC;";	
			}
			
			
			if($tipo=='porvencer'){
				$sql = "SELECT CONCAT(cc.nombre,' ',cc.apepat) as cliente,b.nombre_pasa_pri,a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='' AND a.fecha_pago<='".$nuevafecha."' AND a.fecha_pago>='".$fecha."' AND (e.valor_servicios>0 AND f.pago_servicios<e.valor_servicios OR f.pago_servicios IS NUll) GROUP BY a.id ORDER BY a.id DESC;";	
			}
			
			if($tipo=='vencidos'){
				$sql = "SELECT CONCAT(cc.nombre,' ',cc.apepat) as cliente,b.nombre_pasa_pri,a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='0000-00-00' AND a.fecha_pago<'".$fecha."' AND (e.valor_servicios>0 AND f.pago_servicios<e.valor_servicios) GROUP BY a.id ORDER BY a.id DESC;";	
			}
			
			if($tipo=='sinfecha'){
				$sql = "SELECT CONCAT(cc.nombre,' ',cc.apepat) as cliente,b.nombre_pasa_pri,a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago='0000-00-00' AND e.valor_servicios>0 AND (f.pago_servicios<e.valor_servicios) GROUP BY a.id ORDER BY a.id DESC;";	
			}
			
			
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	
	public function getServiciosPagosFiltroPROV($id_prov,$desde,$nombre,$nombre2,$fechab,$tipo){
		try{
			$conexion = Conectar::con();	
			$buscar='';
			
			if($nombre!=''){$buscar=$buscar."(cc.nombre LIKE '%".$nombre."%' OR cc.apepat LIKE '%".$nombre."%') AND ";}
			if($nombre2!=''){$buscar=$buscar."b.nombre_pasa_pri LIKE '%".$nombre2."%' AND ";}
			if($fechab!=''){$buscar=$buscar."a.fecha_pago='".$fechab."' AND ";}
			if($id_prov!=''){$buscar=$buscar."c.id=".$id_prov." AND ";}
			
			$fecha = date('Y-m-j');
			$nuevafecha = strtotime ( '+7 day' , strtotime ( $fecha ) ) ;
			$nuevafecha = date ( 'Y-m-j' , $nuevafecha );
			
			if($tipo=='pendientes'){
				$sql = "SELECT b.nota,CONCAT(cc.nombre,' ',cc.apepat) as cliente,b.nombre_pasa_pri,a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND (f.pago_servicios is null OR f.pago_servicios='') GROUP BY a.id ORDER BY a.id DESC LIMIT 10 OFFSET ?;";	
			}
			
			if($tipo=='incompletos'){
				$sql = "SELECT b.nota,CONCAT(cc.nombre,' ',cc.apepat) as cliente,b.nombre_pasa_pri,a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  f.pago_servicios<e.valor_servicios GROUP BY a.id ORDER BY a.id DESC LIMIT 10 OFFSET ?;";	
			}
			
			if($tipo=='pagados'){
				$sql = "SELECT b.nota,CONCAT(cc.nombre,' ',cc.apepat) as cliente,b.nombre_pasa_pri,a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  f.pago_servicios>=e.valor_servicios GROUP BY a.id ORDER BY a.id DESC LIMIT 10 OFFSET ?;";	
			}
			
			
			if($tipo=='porvencer'){
				$sql = "SELECT b.nota,CONCAT(cc.nombre,' ',cc.apepat) as cliente,b.nombre_pasa_pri,a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='' AND a.fecha_pago<='".$nuevafecha."' AND a.fecha_pago>='".$fecha."' AND (e.valor_servicios>0 AND f.pago_servicios<e.valor_servicios OR f.pago_servicios IS NUll) GROUP BY a.id ORDER BY a.id DESC LIMIT 10 OFFSET ?;";	
			}
			
			if($tipo=='vencidos'){
				$sql = "SELECT b.nota,CONCAT(cc.nombre,' ',cc.apepat) as cliente,b.nombre_pasa_pri,a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='0000-00-00' AND a.fecha_pago<'".$fecha."' AND (e.valor_servicios>0 AND f.pago_servicios<e.valor_servicios) GROUP BY a.id ORDER BY a.id DESC LIMIT 10 OFFSET ?;";	
			}
			
			if($tipo=='sinfecha'){
				$sql = "SELECT b.nota,CONCAT(cc.nombre,' ',cc.apepat) as cliente,b.nombre_pasa_pri,a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago='0000-00-00' AND e.valor_servicios>0 AND (f.pago_servicios<e.valor_servicios) GROUP BY a.id ORDER BY a.id DESC LIMIT 10 OFFSET ?;";	
			}
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$desde);	
			$sentencia->execute();
			
			$sentencia->bind_result($nota,$cliente,$pasajero,$fecha_pago,$id,$id_proveedor,$id_negocio,$f_crea,$valor,$tipo_cambio,$valor_tipo_cambio,$destino,$nombre,$rut,$valor_servicios,$pago_servicios);
			$arr = array();
			$i=0; 
			while ($sentencia->fetch()) {
				$arr[$i]['fecha_pago']=$fecha_pago;
				$arr[$i]['id']=$id;
				$arr[$i]['id_proveedor']=$id_proveedor;
				$arr[$i]['id_negocio']=$id_negocio;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['valor']=$valor;
				$arr[$i]['tipo_cambio']=$tipo_cambio;
				$arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr[$i]['destino']=$destino;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['rut']=$rut;
				$arr[$i]['valor_servicios']=$valor_servicios;
				$arr[$i]['pago_servicios']=$pago_servicios;
				$arr[$i]['cliente']=$cliente;
				$arr[$i]['pasajero']=$pasajero;
				$arr[$i]['nota']=$nota;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	public function getServiciosPagosCountPROV($id_prov,$nombre,$nombre2,$fechab){
		try{
			$conexion = Conectar::con();		
			$buscar='';
			$fecha = date('Y-m-j');
			$nuevafecha = strtotime ( '+7 day' , strtotime ( $fecha ) ) ;
			$nuevafecha = date ( 'Y-m-j' , $nuevafecha );
			
			if($nombre!=''){$buscar=$buscar." (cc.nombre LIKE '%".$nombre."%' OR cc.apepat LIKE '%".$nombre."%') AND ";}
			if($nombre2!=''){$buscar=$buscar."b.nombre_pasa_pri LIKE '%".$nombre2."%' AND ";}
			if($fechab!=''){$buscar=$buscar."a.fecha_pago='".$fechab."' AND ";}
			if($id_prov!=''){$buscar=$buscar."c.id=".$id_prov." AND ";}
			
			
			$sql = "SELECT * FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND (f.pago_servicios is null OR f.pago_servicios='') GROUP BY a.id ORDER BY a.id DESC;";	
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$pendientes=$sentencia->num_rows;
			
			$sql = "SELECT * FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  f.pago_servicios<e.valor_servicios GROUP BY a.id ORDER BY a.id DESC;";	
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$incompletos=$sentencia->num_rows;
			
			$sql = "SELECT * FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  f.pago_servicios>=e.valor_servicios GROUP BY a.id ORDER BY a.id DESC;";	
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$pagados=$sentencia->num_rows;
			
			$sql = "SELECT * FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='' AND a.fecha_pago<='".$nuevafecha."' AND a.fecha_pago>='".$fecha."' AND (e.valor_servicios>0 AND f.pago_servicios<e.valor_servicios OR f.pago_servicios IS NUll) GROUP BY a.id ORDER BY a.id DESC;";	
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$porvencer=$sentencia->num_rows;
			
			$sql = "SELECT * FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='0000-00-00' AND a.fecha_pago<'".$fecha."' AND (e.valor_servicios>0 AND f.pago_servicios<e.valor_servicios) GROUP BY a.id ORDER BY a.id DESC;";	
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$vencidos=$sentencia->num_rows;
			
			$sql = "SELECT * FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as cc ON b.id_cliente=cc.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago='0000-00-00' AND e.valor_servicios>0 AND (f.pago_servicios<e.valor_servicios) GROUP BY a.id ORDER BY a.id DESC;";	
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$sinfecha=$sentencia->num_rows;
			
			
			return array('pendientes'=>$pendientes,'incompletos'=>$incompletos,'pagados'=>$pagados,'porvencer'=>$porvencer,'vencidos'=>$vencidos,'sinfecha'=>$sinfecha);
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	
	public function borrarContacto($id){
		try{
			$sql = "DELETE FROM contactos_proveedores WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function getContacto($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,id_proveedor,id_us_crea,f_crea,nombre,cargo,fono,fono_movil,email,nota FROM contactos_proveedores WHERE id_proveedor=?;";

			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);	
			$sentencia->execute();
			$sentencia->bind_result($id,$id_proveedor,$id_us_crea,$f_crea,$nombre,$cargo,$fono,$fono_movil,$email,$nota);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['id_proveedor']=$id_proveedor;
				$arr[$i]['id_us_crea']=$id_us_crea;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['cargo']=$cargo;
				$arr[$i]['fono']=$fono;
				$arr[$i]['fono_movil']=$fono_movil;
				$arr[$i]['email']=$email;
				$arr[$i]['nota']=$nota;
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	public function creaContacto($datos){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			
			$sql = "INSERT INTO contactos_proveedores(id_proveedor,id_us_crea,nombre,cargo,fono,fono_movil,email,nota,f_crea) VALUES(?,?,?,?,?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("iisssssss",$datos['id_proveedor'],$datos['id_us_crea'],$datos['nombre'],$datos['cargo'],$datos['fono'],$datos['fono_movil'],$datos['email'],$datos['nota'],$fec_crea);
			$sentencia->execute();

			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;
			}
	
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}

	public function paginas($nombre,$rut){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			$buscar ="";
			
			if($nombre!=""){
				$buscar = "nombre LIKE '%".$nombre."%' AND";
			}
			
			if($rut!=""){
				$buscar = "rut LIKE '%".$rut."%' AND";
			}
			
			
			
			$sql = "SELECT * FROM proveedores WHERE ".$buscar." id is not NULL;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}

	public function getProveedores($desde,$nombre,$rut){
		try{
			$conexion = Conectar::con();
			$buscar ="";
			
			if($nombre!=""){
				$buscar = "nombre LIKE '%".$nombre."%' AND";
			}
			
			if($rut!=""){
				$buscar = "rut LIKE '%".$rut."%' AND";
			}
			
			
			$sql = "SELECT id,nombre,rut,fono1,estado FROM proveedores WHERE ".$buscar." id is not NULL ORDER BY nombre ASC LIMIT 10 OFFSET ?;";
			
			
			
			 
			//$sql = "SELECT id,nombre,rut,fono1 FROM proveedores LIMIT 10,? ORDER BY id ASC"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$desde);	
			$sentencia->execute();
			
			$sentencia->bind_result($id,$nombre,$rut,$fono1,$estado);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['rut']=$rut;
				$arr[$i]['fono1']=$fono1;
				$arr[$i]['estado']=$estado;
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
	
	public function getProveedoresl($letra,$desde,$nombre,$rut){
		try{
			$conexion = Conectar::con();
			$buscar ="";
			
			if($nombre!=""){
				$buscar = "nombre LIKE '%".$nombre."%' AND";
			}
			
			if($rut!=""){
				$buscar = "rut LIKE '%".$rut."%' AND";
			}
			
			
			$sql = "SELECT id,nombre,rut,fono1,estado FROM proveedores WHERE ".$buscar." nombre LIKE '".$letra."%' ORDER BY nombre ASC;";
			
			
			
			 
			//$sql = "SELECT id,nombre,rut,fono1 FROM proveedores LIMIT 10,? ORDER BY id ASC"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			
			$sentencia->bind_result($id,$nombre,$rut,$fono1,$estado);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['rut']=$rut;
				$arr[$i]['fono1']=$fono1;
				$arr[$i]['estado']=$estado;
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}


	public function rutProvExiste ($rut){
		try{
			if($rut=="" || $rut== null || $rut == "null"){
				return "error";
			}else{
				$conexion = Conectar::con();
				$sql = "SELECT * FROM proveedores WHERE rut=?;";
				
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("s",$rut);		
				$sentencia->execute();
				
				$sentencia->store_result();
				return $sentencia->num_rows;
				
				$conexion->close();
				$sentencia->close();
				
				
			}		
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}

	public function crearProveedor($datos){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			$neto="";
			$masiva="";
			$masivainc="";
			
			if($datos['tarifa']=='comisionable'){
				$neto=$datos['neto'];
				$masiva=$datos['masiva'];
				$masivainc=$datos['masivainc'];
			}
			
			
			
			
			$sql = "INSERT INTO proveedores(rut,nombre,us_creador,fecha_creacion,pais,ciudad,comuna,codpostal,direccion,fono1,fono2,email,web,banco,cambiodolar,cambiopeso,observaciones,tipo_proveedor,tipo_venta,razon_social,forma_pago,estado,giro,fono_emergencia,num_f_emergencia,tarifa,neto,masiva,masivainc) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ssissssssssssssssssssisssssss",$datos['rut_proveedor'],trim($datos['nombre_proveedor']),$datos['usuario_id'],$fec_crea,$datos['pais_proveedor'],$datos['ciudad_proveedor'],$datos['comuna_proveedor'],$datos['cp_proveedor'],$datos['direccion_proveedor'],$datos['fono1_proveedor'],$datos['fono2_proveedor'],$datos['email_proveedor'],$datos['web_proveedor'],$datos['banco_proveedor'],$datos['dolares_proveedor'],$datos['pesos_proveedor'],$datos['observaciones_proveedor'],$datos['tipo_proveedor'],$datos['tipo_venta'],$datos['razon_social'],$datos['forma_pago'],$datos['estado'],$datos['giro'],$datos['fono_emergencia'],$datos['num_f_emergencia'],$datos['tarifa'],$neto,$masiva,$masivainc);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				header("Location:proveedores_ficha.php?id_prov=".$conexion->insert_id);
				exit();
			}
	
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function actualizaProveedor($datos){
		try{
			$neto="";
			$masiva="";
			$masivainc="";
			
			if($datos['tarifa']=='comisionable'){
				$neto=$datos['neto'];
				$masiva=$datos['masiva'];
				$masivainc=$datos['masivainc'];
			}
			
			
			
			
			$conexion = Conectar::con();
			$sql="UPDATE proveedores set rut=?,nombre=?,pais=?,ciudad=?,comuna=?,codpostal=?,direccion=?,fono1=?,fono2=?,email=?,web=?,banco=?,cambiodolar=?,cambiopeso=?,observaciones=?,tipo_proveedor=?,razon_social=?,forma_pago=?,estado=?,giro=?,fono_emergencia=?,num_f_emergencia=?,tarifa=?,neto=?,masiva=?,masivainc=? WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$nombre_proveedor=trim($datos['nombre_proveedor']);
			$sentencia->bind_param("ssssssssssssssssssisssssssi",$datos['rut_proveedor'],$nombre_proveedor,$datos['pais_proveedor'],$datos['ciudad_proveedor'],$datos['comuna_proveedor'],$datos['cp_proveedor'],$datos['direccion_proveedor'],$datos['fono1_proveedor'],$datos['fono2_proveedor'],$datos['email_proveedor'],$datos['web_proveedor'],$datos['banco_proveedor'],$datos['dolares_proveedor'],$datos['pesos_proveedor'],$datos['observaciones_proveedor'],$datos['tipo_proveedor'],$datos['razon_social'],$datos['forma_pago'],$datos['estado'],$datos['giro'],$datos['fono_emergencia'],$datos['num_f_emergencia'],$datos['tarifa'],$neto,$masiva,$masivainc,$datos['codigo_proveedor']);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function creaServicio($datos){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			$sql="INSERT INTO proveedores_servicios(id_proveedor,descripcion,valor,cambiodolar,cambiopeso,incluyeiva,f_creacion,confirmacion) VALUES(?,?,?,?,?,?,?,?)";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("isssssss",$datos['codigo_proveedor'],$datos['descripcion'],$datos['valor'],$datos['tipocambio_dolares'],$datos['tipocambio_pesos'],$datos['iva'],$fec_crea,$datos['confirm']);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;// retorna el id creado
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function borrarServicio($id){
		try{
			$sql = "DELETE FROM proveedores_servicios WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function getProveedoresbyID($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT tarifa,neto,masiva,masivainc,id,rut,nombre,us_creador,fecha_creacion,pais,ciudad,comuna,codpostal,direccion,fono1,fono2,email,web,banco,cambiodolar,cambiopeso,observaciones,tipo_proveedor,tipo_venta,razon_social,forma_pago,estado,giro,fono_emergencia,num_f_emergencia FROM proveedores where id=? limit 1;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			
			
			//id,rut,nombre,us_creador,fecha_creacion,pais,ciudad,comuna,codpostal,direccion,fono1,fono2,email,web,banco,cambiodolar,cambiopeso,observaciones
			
			$sentencia->bind_result($tarifa,$neto,$masiva,$masivainc,$id,$rut,$nombre,$us_creador,$fecha_creacion,$pais,$ciudad,$comuna,$codpostal,$direccion,$fono1,$fono2,$email,$web,$banco,$cambiodolar,$cambiopeso,$observaciones,$tipo_proveedor,$tipo_venta,$razon_social,$forma_pago,$estado,$giro,$fono_emergencia,$num_f_emergencia);
			$arr = array();
			 while ($sentencia->fetch()) {
				$arr['id']=$id;
				$arr['rut']=$rut;
				$arr['nombre']=$nombre;
				$arr['us_creador']=$us_creador;
				$arr['fecha_creacion']=$fecha_creacion;
				$arr['pais']=$pais;
				$arr['ciudad']=$ciudad;
				$arr['comuna']=$comuna;
				$arr['codpostal']=$codpostal;
				$arr['direccion']=$direccion;
				$arr['fono1']=$fono1;
				$arr['fono2']=$fono2;
				$arr['email']=$email;
				$arr['web']=$web;
				$arr['banco']=$banco;
				$arr['cambiodolar']=$cambiodolar;
				$arr['cambiopeso']=$cambiopeso;
				$arr['observaciones']=$observaciones;
				$arr['tipo_proveedor']=$tipo_proveedor;
				$arr['tipo_venta']=$tipo_venta;
				$arr['razon_social']=$razon_social;
				$arr['forma_pago']=$forma_pago;
				$arr['estado']=$estado;
				$arr['giro']=$giro;
				$arr['fono_emergencia']=$fono_emergencia;
				$arr['num_f_emergencia']=$num_f_emergencia;
				$arr['tarifa']=$tarifa;
				$arr['neto']=$neto;
				$arr['masiva']=$masiva;
				$arr['masivainc']=$masivainc;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	public function getServiciosbyID($id_prov){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,id_proveedor,descripcion,valor,cambiodolar,cambiopeso,incluyeiva,f_creacion,confirmacion FROM proveedores_servicios where id_proveedor=? ORDER BY id ASC"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id_prov);
			$sentencia->execute();
			
			$sentencia->bind_result($id,$id_proveedor,$descripcion,$valor,$cambiodolar,$cambiopeso,$incluyeiva,$f_creacion,$confirmacion);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch()) {
				$arr[$i]['id']=$id;
				$arr[$i]['id_proveedor']=$id_proveedor;
				$arr[$i]['descripcion']=$descripcion;
				$arr[$i]['valor']=$valor;
				$arr[$i]['cambiodolar']=$cambiodolar;
				$arr[$i]['cambiopeso']=$cambiopeso;
				$arr[$i]['incluyeiva']=$incluyeiva;
				$arr[$i]['f_creacion']=$f_creacion;
				$arr[$i]['confirmacion']=$confirmacion;
				
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	public function servPaginas($id_prov,$desde,$id_serv,$id_neg,$nom_cli,$rut_cli,$destino,$tipo_cambio){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			$buscar="";
			
			if($id_serv!=""){
				$buscar=$buscar." a.id=".$id_serv." AND";
			}
			if($id_neg!=""){
				$buscar=$buscar." a.id_negocio=".$id_neg." AND";
			}
			if($nom_cli!=""){
				$buscar=$buscar." c.nombre LIKE '%".$nom_cli."%' AND";
			}
			if($rut_cli!=""){
				$buscar=$buscar." c.rut LIKE '%".$rut_cli."%' AND";
			}
			if($destino!=""){
				$buscar=$buscar." b.destino LIKE '%".$destino."%' AND";
			}
			if($tipo_cambio!="" && $tipo_cambio!="ambos"){
				$buscar=$buscar." a.tipo_cambio LIKE '%".$tipo_cambio."%' AND";
			}
			
			
			$sql = "SELECT * FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as c ON b.id_cliente=c.id WHERE".$buscar." a.id_proveedor=? ORDER BY a.id ASC LIMIT 10 OFFSET ?;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ii",$id_prov,$desde);
			$sentencia->execute();
			
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	
	
	public function servPaginasPROV($id_prov,$id_serv,$id_neg,$nom_cli,$rut_cli,$destino,$tipo_cambio){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			$buscar="";
			
			if($id_serv!=""){
				$buscar=$buscar." a.fecha_pago='".$id_serv."' AND";
			}
			if($id_neg!=""){
				$buscar=$buscar." a.id_negocio=".$id_neg." AND";
			}
			if($nom_cli!=""){
				$buscar=$buscar." c.nombre LIKE '%".$nom_cli."%' AND";
			}
			if($rut_cli!=""){
				$buscar=$buscar." b.nombre_pasa_pri LIKE '%".$rut_cli."%' AND";
			}
			if($destino!=""){
				$buscar=$buscar." b.destino LIKE '%".$destino."%' AND";
			}
			if($tipo_cambio!="" && $tipo_cambio!="ambos"){
				$buscar=$buscar." a.tipo_cambio LIKE '%".$tipo_cambio."%' AND";
			}
			
			
			$sql = "SELECT * FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as c ON b.id_cliente=c.id WHERE".$buscar." a.id_proveedor=? ORDER BY a.id ASC;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id_prov);
			$sentencia->execute();
			
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	public function getServiciosbyIDprovPROV($id_prov,$desde,$id_serv,$id_neg,$nom_cli,$rut_cli,$destino,$tipo_cambio){
		try{
			$conexion = Conectar::con();
			$buscar="";
			
			if($id_serv!=""){
				$buscar=$buscar." a.fecha_pago='".$id_serv."' AND";
			}
			if($id_neg!=""){
				$buscar=$buscar." a.id_negocio=".$id_neg." AND";
			}
			if($nom_cli!=""){
				$buscar=$buscar." c.nombre LIKE '%".$nom_cli."%' OR  c.apepat LIKE '%".$nom_cli."%' AND";
			}
			if($rut_cli!=""){
				$buscar=$buscar." b.nombre_pasa_pri LIKE '%".$rut_cli."%' AND";
			}
			if($destino!=""){
				$buscar=$buscar." b.destino LIKE '%".$destino."%' AND";
			}
			if($tipo_cambio!="" && $tipo_cambio!="ambos"){
				$buscar=$buscar." a.tipo_cambio LIKE '%".$tipo_cambio."%' AND";
			}
			
			
			$sql = "SELECT b.nota,b.nombre_pasa_pri,a.id,a.id_negocio,a.fecha_pago,a.valor,a.tipo_cambio,b.destino,c.nombre,c.apepat,c.rut FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as c ON b.id_cliente=c.id WHERE".$buscar." a.id_proveedor=? ORDER BY a.fecha_pago ASC LIMIT 10 OFFSET ?;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ii",$id_prov,$desde);
			$sentencia->execute();
			
			$sentencia->bind_result($nota,$nom_pasa_pri,$id,$id_negocio,$f_crea,$valor,$tipo_cambio,$destino,$nombre,$apepat,$rut);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch()) {
				$arr[$i]['id']=$id;
				$arr[$i]['id_negocio']=$id_negocio;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['valor']=$valor;
				$arr[$i]['tipo_cambio']=$tipo_cambio;
				$arr[$i]['destino']=$destino;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['apepat']=$apepat;
				$arr[$i]['rut']=$rut;
				$arr[$i]['nom_pasa_pri']=$nom_pasa_pri;
				$arr[$i]['nota']=$nota;
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	public function getServiciosbyIDprov($id_prov,$desde,$id_serv,$id_neg,$nom_cli,$rut_cli,$destino,$tipo_cambio){
		try{
			$conexion = Conectar::con();
			$buscar="";
			
			if($id_serv!=""){
				$buscar=$buscar." a.id=".$id_serv." AND";
			}
			if($id_neg!=""){
				$buscar=$buscar." a.id_negocio=".$id_neg." AND";
			}
			if($nom_cli!=""){
				$buscar=$buscar." c.nombre LIKE '%".$nom_cli."%' AND";
			}
			if($rut_cli!=""){
				$buscar=$buscar." c.rut LIKE '%".$rut_cli."%' AND";
			}
			if($destino!=""){
				$buscar=$buscar." b.destino LIKE '%".$destino."%' AND";
			}
			if($tipo_cambio!="" && $tipo_cambio!="ambos"){
				$buscar=$buscar." a.tipo_cambio LIKE '%".$tipo_cambio."%' AND";
			}
			
			
			$sql = "SELECT a.id,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,b.destino,c.nombre,c.apepat,c.rut FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as c ON b.id_cliente=c.id WHERE".$buscar." a.id_proveedor=? ORDER BY a.id ASC LIMIT 10 OFFSET ?;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ii",$id_prov,$desde);
			$sentencia->execute();
			
			$sentencia->bind_result($id,$id_negocio,$f_crea,$valor,$tipo_cambio,$destino,$nombre,$apepat,$rut);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch()) {
				$arr[$i]['id']=$id;
				$arr[$i]['id_negocio']=$id_negocio;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['valor']=$valor;
				$arr[$i]['tipo_cambio']=$tipo_cambio;
				$arr[$i]['destino']=$destino;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['apepat']=$apepat;
				$arr[$i]['rut']=$rut;
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	public function getServiciosPagosbyIDprov($id_prov){
		try{
			$conexion = Conectar::con();			
			$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE a.id_proveedor=? GROUP BY a.id ORDER BY a.id DESC;";
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id_prov);
			$sentencia->execute();
			
			$sentencia->bind_result($fecha_pago,$id,$id_proveedor,$id_negocio,$f_crea,$valor,$tipo_cambio,$valor_tipo_cambio,$destino,$nombre,$rut,$valor_servicios,$pago_servicios);
			$arr = array();
			$i=0; 
			
			while ($sentencia->fetch()) {
				$arr[$i]['fecha_pago']=$fecha_pago;
				$arr[$i]['id']=$id;
				$arr[$i]['id_proveedor']=$id_proveedor;
				$arr[$i]['id_negocio']=$id_negocio;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['valor']=$valor;
				$arr[$i]['tipo_cambio']=$tipo_cambio;
				$arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr[$i]['destino']=$destino;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['rut']=$rut;
				$arr[$i]['valor_servicios']=$valor_servicios;
				$arr[$i]['pago_servicios']=$pago_servicios;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	public function getServiciosID($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT a.id,a.id_negocio,a.f_crea,a.confirmacion,a.esta_confirm,a.valor,a.tipo_cambio,a.descripcion,b.destino,b.f_inicio,b.f_termino,CONCAT(c.nombre,' ',c.apepat,' (',c.rut,')') as cliente,CONCAT(d.nombre,' (',d.rut,')') as proveedor FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as c ON b.id_cliente=c.id LEFT JOIN proveedores as d ON a.id_proveedor=d.id WHERE a.id=?;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$sentencia->bind_result($id,$id_negocio,$f_crea,$confirmacion,$esta_confirm,$valor,$tipo_cambio,$descripcion,$destino,$f_inicio,$f_termino,$cliente,$proveedor);
			$arr = array();
			 while ($sentencia->fetch()) {
				$arr['id']=$id;
				$arr['id_negocio']=$id_negocio;
				$arr['f_crea']=$f_crea;
				$arr['confirmacion']=$confirmacion;
				$arr['esta_confirm']=$esta_confirm;
				$arr['valor']=$valor;
				$arr['tipo_cambio']=$tipo_cambio;
				$arr['descripcion']=$descripcion;
				$arr['destino']=$destino;
				$arr['f_inicio']=$f_inicio;
				$arr['f_termino']=$f_termino;
				$arr['cliente']=$cliente;
				$arr['proveedor']=$proveedor;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	public function getServiciosTotal($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT monto from pagos_serv WHERE id_servicio=?"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$sentencia->bind_result($monto);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch()) {
				$arr[$i]['monto']=$monto;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	
}

class clientes extends Conectar{
	public function borrarCliente($id){
		try{
			$sql = "DELETE FROM clientes WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function rutCliNoExiste ($rut){
		try{
			if($rut=="" || $rut== null || $rut == "null"){
				return "error";
			}else{
				$conexion = Conectar::con();
				$sql = "SELECT * FROM clientes WHERE rut=?;";
				
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("s",$rut);		
				$sentencia->execute();
				
				$sentencia->store_result();
				return $sentencia->num_rows;
				
				$conexion->close();
				$sentencia->close();
				
				
			}		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function rutCliExiste ($rut){
		try{
			if($rut=="" || $rut== null || $rut == "null"){
				return "error";
			}else{
				$conexion = Conectar::con();
				$sql = "SELECT * FROM clientes WHERE rut=?;";
				
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("s",$rut);		
				$sentencia->execute();
				
				$sentencia->store_result();
				return $sentencia->num_rows;
				
				$conexion->close();
				$sentencia->close();
				
				
			}		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function crearCliente($datos){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			
			if($datos['tipo_cliente']=='Empresa'){
				$apepat='';
				$apemat='';
				$razon_social=$datos['razon_cliente'];
			}else{
				$apepat=$datos['apepat'];
				$apemat=$datos['apemat'];
				$razon_social='';
			}
			
			
			$sql = "INSERT INTO clientes(cuenta,rut,us_creador,fecha_creacion,nombre,apepat,apemat,pais,ciudad,comuna,direccion,fono1,fono2,email,banco,observaciones,codpostal,f_nac,pasaporte,tipo_cliente,razon_social) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$nombre_cliente=trim($datos['nombre']);
			$apepat_cliente=trim($apepat);
			$sentencia->bind_param("ssissssssssssssssssss",$datos['cuenta'],$datos['rut'],$datos['usuario_id'],$fec_crea,$nombre_cliente,$apepat_cliente,$apemat,$datos['pais'],$datos['ciudad'],$datos['comuna'],$datos['direccion'],$datos['fono1'],$datos['fono2'],$datos['email'],$datos['banco'],$datos['observaciones'],$datos['cp'],$datos['f_nac'],$datos['pasaporte'],$datos['tipo_cliente'],$razon_social);
			$sentencia->execute();
			
			
			
			
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;// retorna el id creado
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function actualizaCliente($datos){
		try{
			$conexion = Conectar::con();
			
			if($datos['tipo_cliente']=='Empresa'){
				$apepat='';
				$apemat='';
				$razon_social=$datos['razon_cliente'];
			}else{
				$apepat=$datos['apepat'];
				$apemat=$datos['apemat'];
				$razon_social='';
			}
			
			$sql="UPDATE clientes set cuenta=?,rut=?,nombre=?,apepat=?,apemat=?,pais=?,ciudad=?,comuna=?,direccion=?,fono1=?,fono2=?,email=?,banco=?,observaciones=?,codpostal=?,f_nac=?,pasaporte=?,tipo_cliente=?,razon_social=? WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$nombre_cliente=trim($datos['nombre']);
			$apepat_cliente=trim($apepat);
			
			$sentencia->bind_param("sssssssssssssssssssi",$datos['cuenta'],$datos['rut'],$nombre_cliente,$apepat_cliente,$apemat,$datos['pais'],$datos['ciudad'],$datos['comuna'],$datos['direccion'],$datos['fono1'],$datos['fono2'],$datos['email'],$datos['banco'],$datos['observaciones'],$datos['cp'],$datos['f_nac'],$datos['pasaporte'],$datos['tipo_cliente'],$razon_social,$datos['codigo']);
			$sentencia->execute();
			
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}	
	
	
	public function paginas($nombre,$rut,$tipo_cliente){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			$buscar ="";
			
			if($nombre!=""){
				$buscar = "nombre LIKE '%".$nombre."%' AND";
			}
			
			if($rut!=""){
				$buscar = "rut LIKE '%".$rut."%' AND";
			}
			
			if($tipo_cliente!="" && $tipo_cliente!="ambos"){
				$buscar = "tipo_cliente='".$tipo_cliente."' AND";
			}
			
			$sql = "SELECT * FROM clientes WHERE ".$buscar." id is not NULL;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}

	public function getClientes($desde,$nombre,$rut,$tipo_cliente){
		try{
			$conexion = Conectar::con();
			$buscar ="";
			
			if($nombre!=""){
				$buscar = " a.nombre LIKE '%".$nombre."%' AND";
			}
			
			if($rut!=""){
				$buscar = " a.rut LIKE '%".$rut."%' AND";
			}
			
			
			if($tipo_cliente!="" && $tipo_cliente!="ambos"){
				$buscar = " a.tipo_cliente='".$tipo_cliente."' AND";
			}
			
			$sql = "SELECT a.id,a.nombre,a.apepat,a.rut,a.fono1,a.tipo_cliente,b.negocio FROM clientes as a LEFT JOIN (SELECT id_cliente,count(id) as negocio FROM negocios GROUP BY id_cliente) as b ON b.id_cliente = a.id WHERE".$buscar." id is not NULL ORDER BY id ASC LIMIT 10 OFFSET ?;";
			
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$desde);	
			$sentencia->execute();
			
			$sentencia->bind_result($id,$nombre,$apepat,$rut,$fono1,$tipo_cliente,$negocio);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['nombre']=$nombre." ".$apepat;
				$arr[$i]['rut']=$rut;
				$arr[$i]['fono1']=$fono1;
				$arr[$i]['tipo_cliente']=$tipo_cliente;
				$arr[$i]['negocio']=$negocio;
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
	public function getClientesl($letra,$desde,$nombre,$rut,$tipo_cliente,$tipo_cuenta){
		try{
			$conexion = Conectar::con();
			$buscar ="";
			
			if($nombre!=""){
				$buscar = " a.nombre LIKE '%".$nombre."%' AND";
			}
			
			if($rut!=""){
				$buscar = " a.rut LIKE '%".$rut."%' AND";
			}
			
			
			if($tipo_cliente!="" && $tipo_cliente!="ambos"){
				$buscar = " a.tipo_cliente='".$tipo_cliente."' AND";
			}
			
			if($tipo_cuenta!="" && $tipo_cuenta!="ambos"){
				$buscar = " a.cuenta='".$tipo_cuenta."' AND";
			}

			$sql = "SELECT a.id,a.nombre,a.apepat,a.rut,a.fono1,a.tipo_cliente,b.negocio,IF(a.apepat='' OR a.apepat IS null ,nombre,apepat) as ordenar FROM clientes as a LEFT JOIN (SELECT id_cliente,count(id) as negocio FROM negocios GROUP BY id_cliente) as b ON b.id_cliente = a.id WHERE".$buscar." IF(a.apepat='' OR a.apepat IS null ,nombre,apepat) LIKE '".$letra."%' ORDER BY ordenar ASC;";
			$sentencia = $conexion->prepare($sql);	
			$sentencia->execute();
			
			$sentencia->bind_result($id,$nombre,$apepat,$rut,$fono1,$tipo_cliente,$negocio,$ordenar);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['nombre']=$apepat." ".$nombre;
				$arr[$i]['rut']=$rut;
				$arr[$i]['fono1']=$fono1;
				$arr[$i]['tipo_cliente']=$tipo_cliente;
				$arr[$i]['negocio']=$negocio;
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	

	public function getClientesbyID($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT cuenta,id,rut,nombre,apepat,apemat,f_nac,us_creador,fecha_creacion,pais,ciudad,comuna,codpostal,direccion,fono1,fono2,email,banco,observaciones,pasaporte,tipo_cliente,razon_social FROM clientes where id=? limit 1;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$sentencia->bind_result($tipo_cuenta,$id,$rut,$nombre,$apepat,$apemat,$f_nac,$us_creador,$fecha_creacion,$pais,$ciudad,$comuna,$codpostal,$direccion,$fono1,$fono2,$email,$banco,$observaciones,$pasaporte,$tipo_cliente,$razon_social);
			$arr = array();
			 while ($sentencia->fetch()) {
				$arr['id']=$id;
				$arr['rut']=$rut;
				$arr['nombre']=$nombre;
				$arr['apepat']=$apepat;
				$arr['apemat']=$apemat;
				$arr['f_nac']=$f_nac;
				$arr['us_creador']=$us_creador;
				$arr['fecha_creacion']=$fecha_creacion;
				$arr['pais']=$pais;
				$arr['ciudad']=$ciudad;
				$arr['comuna']=$comuna;
				$arr['codpostal']=$codpostal;
				$arr['direccion']=$direccion;
				$arr['fono1']=$fono1;
				$arr['fono2']=$fono2;
				$arr['email']=$email;
				$arr['banco']=$banco;
				$arr['observaciones']=$observaciones;
				$arr['pasaporte']=$pasaporte;
				$arr['tipo_cliente']=$tipo_cliente;
				$arr['razon_social']=$razon_social;
				$arr['tipo_cuenta']=$tipo_cuenta;
				
				
				
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	
	
	
	
	public function getPagosClientesbyIDCLIpag($id_cli,$nombre,$fechab,$cuenta,$tipo){
		try{
			$conexion = Conectar::con();
			$registros_porp = 10;			
			$buscar='';
			
			if($nombre!=''){$buscar=$buscar." (a.destino LIKE '%".$nombre."%') AND ";}
			if($fechab!=''){$buscar=$buscar." a.f_inicio='".$fechab."' AND ";}
			if($cuenta!=''){$buscar=$buscar." a.tipo_cuenta='".$cuenta."' AND ";}
			
			
			if($tipo==''){
				$sql = "SELECT a.id,a.id_us_crea,a.id_cliente,a.tipo_cuenta,a.destino,a.f_crea,a.f_inicio,a.f_termino,a.n_pasajero,a.precio,a.valor_tipo_cambio,a.tipo_cambio,if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio) as preciopesos,b.pagospesos FROM negocios as a LEFT JOIN(SELECT c.id_negocio,SUM(if(c.tipo_moneda='DOLAR',c.monto*d.valor_tipo_cambio,c.monto)) as pagospesos FROM pagos_negocio_cli as c LEFT JOIN negocios as d ON c.id_negocio=d.id GROUP BY c.id_negocio) as b ON b.id_negocio=a.id WHERE a.id IS NOT NULL AND ".$buscar." a.id_cliente=?;";	
			}
			
			if($tipo=='pendientes'){
				$sql = "SELECT a.id,a.id_us_crea,a.id_cliente,a.tipo_cuenta,a.destino,a.f_crea,a.f_inicio,a.f_termino,a.n_pasajero,a.precio,a.valor_tipo_cambio,a.tipo_cambio,if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio) as preciopesos,b.pagospesos FROM negocios as a LEFT JOIN(SELECT c.id_negocio,SUM(if(c.tipo_moneda='DOLAR',c.monto*d.valor_tipo_cambio,c.monto)) as pagospesos FROM pagos_negocio_cli as c LEFT JOIN negocios as d ON c.id_negocio=d.id GROUP BY c.id_negocio) as b ON b.id_negocio=a.id WHERE (b.pagospesos='' OR  b.pagospesos=0 OR b.pagospesos IS NULL) AND ".$buscar." a.id_cliente=?;";	
			}
			
			if($tipo=='abonados'){
				$sql = "SELECT a.id,a.id_us_crea,a.id_cliente,a.tipo_cuenta,a.destino,a.f_crea,a.f_inicio,a.f_termino,a.n_pasajero,a.precio,a.valor_tipo_cambio,a.tipo_cambio,if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio) as preciopesos,b.pagospesos FROM negocios as a LEFT JOIN(SELECT c.id_negocio,SUM(if(c.tipo_moneda='DOLAR',c.monto*d.valor_tipo_cambio,c.monto)) as pagospesos FROM pagos_negocio_cli as c LEFT JOIN negocios as d ON c.id_negocio=d.id GROUP BY c.id_negocio) as b ON b.id_negocio=a.id WHERE (b.pagospesos<>'' OR  b.pagospesos<>0 OR b.pagospesos IS NOT NULL) AND (if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio))>b.pagospesos AND ".$buscar." a.id_cliente=?;";	
			}
			
			if($tipo=='pagados'){
				$sql = "SELECT a.id,a.id_us_crea,a.id_cliente,a.tipo_cuenta,a.destino,a.f_crea,a.f_inicio,a.f_termino,a.n_pasajero,a.precio,a.valor_tipo_cambio,a.tipo_cambio,if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio) as preciopesos,b.pagospesos FROM negocios as a LEFT JOIN(SELECT c.id_negocio,SUM(if(c.tipo_moneda='DOLAR',c.monto*d.valor_tipo_cambio,c.monto)) as pagospesos FROM pagos_negocio_cli as c LEFT JOIN negocios as d ON c.id_negocio=d.id GROUP BY c.id_negocio) as b ON b.id_negocio=a.id WHERE (b.pagospesos<>'' OR  b.pagospesos<>0 OR b.pagospesos IS NOT NULL) AND (if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio))<=b.pagospesos AND ".$buscar." a.id_cliente=?;";		
			}
			
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id_cli);
			$sentencia->execute();
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	
	public function getPagosClientesbyIDCLI($id_cli,$desde,$nombre,$fechab,$cuenta,$tipo){
		try{
			$conexion = Conectar::con();	
			$buscar='';
			
			if($nombre!=''){$buscar=$buscar." (a.destino LIKE '%".$nombre."%') AND ";}
			if($fechab!=''){$buscar=$buscar." a.f_inicio='".$fechab."' AND ";}
			if($cuenta!=''){$buscar=$buscar." a.tipo_cuenta='".$cuenta."' AND ";}
			

			if($tipo==''){
				$sql = "SELECT a.id,a.id_us_crea,a.id_cliente,a.tipo_cuenta,a.destino,a.f_crea,a.f_inicio,a.f_termino,a.n_pasajero,a.precio,a.valor_tipo_cambio,a.tipo_cambio,if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio) as preciopesos,b.pagospesos FROM negocios as a LEFT JOIN(SELECT c.id_negocio,SUM(if(c.tipo_moneda='DOLAR',c.monto*d.valor_tipo_cambio,c.monto)) as pagospesos FROM pagos_negocio_cli as c LEFT JOIN negocios as d ON c.id_negocio=d.id GROUP BY c.id_negocio) as b ON b.id_negocio=a.id WHERE a.id IS NOT NUll AND ".$buscar." a.id_cliente=? ORDER BY a.f_inicio DESC LIMIT 10 OFFSET ?;";	
			}
			
			if($tipo=='pendientes'){
				$sql = "SELECT a.id,a.id_us_crea,a.id_cliente,a.tipo_cuenta,a.destino,a.f_crea,a.f_inicio,a.f_termino,a.n_pasajero,a.precio,a.valor_tipo_cambio,a.tipo_cambio,if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio) as preciopesos,b.pagospesos FROM negocios as a LEFT JOIN(SELECT c.id_negocio,SUM(if(c.tipo_moneda='DOLAR',c.monto*d.valor_tipo_cambio,c.monto)) as pagospesos FROM pagos_negocio_cli as c LEFT JOIN negocios as d ON c.id_negocio=d.id GROUP BY c.id_negocio) as b ON b.id_negocio=a.id WHERE (b.pagospesos='' OR  b.pagospesos=0 OR b.pagospesos IS NULL) AND ".$buscar." a.id_cliente=? ORDER BY a.f_inicio DESC LIMIT 10 OFFSET ?;";	
			}
			
			if($tipo=='abonados'){
				$sql = "SELECT a.id,a.id_us_crea,a.id_cliente,a.tipo_cuenta,a.destino,a.f_crea,a.f_inicio,a.f_termino,a.n_pasajero,a.precio,a.valor_tipo_cambio,a.tipo_cambio,if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio) as preciopesos,b.pagospesos FROM negocios as a LEFT JOIN(SELECT c.id_negocio,SUM(if(c.tipo_moneda='DOLAR',c.monto*d.valor_tipo_cambio,c.monto)) as pagospesos FROM pagos_negocio_cli as c LEFT JOIN negocios as d ON c.id_negocio=d.id GROUP BY c.id_negocio) as b ON b.id_negocio=a.id WHERE (b.pagospesos<>'' OR  b.pagospesos<>0 OR b.pagospesos IS NOT NULL) AND (if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio))>b.pagospesos AND ".$buscar." a.id_cliente=? ORDER BY a.f_inicio DESC LIMIT 10 OFFSET ?;";	
			}
			
			if($tipo=='pagados'){
				$sql = "SELECT a.id,a.id_us_crea,a.id_cliente,a.tipo_cuenta,a.destino,a.f_crea,a.f_inicio,a.f_termino,a.n_pasajero,a.precio,a.valor_tipo_cambio,a.tipo_cambio,if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio) as preciopesos,b.pagospesos FROM negocios as a LEFT JOIN(SELECT c.id_negocio,SUM(if(c.tipo_moneda='DOLAR',c.monto*d.valor_tipo_cambio,c.monto)) as pagospesos FROM pagos_negocio_cli as c LEFT JOIN negocios as d ON c.id_negocio=d.id GROUP BY c.id_negocio) as b ON b.id_negocio=a.id WHERE (b.pagospesos<>'' OR  b.pagospesos<>0 OR b.pagospesos IS NOT NULL) AND (if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio))<=b.pagospesos AND ".$buscar." a.id_cliente=? ORDER BY a.f_inicio DESC LIMIT 10 OFFSET ?;";		
			}
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ii",$id_cli,$desde);	
			$sentencia->execute();
			
			$sentencia->bind_result($id,$id_us_crea,$id_cliente,$tipo_cuenta,$destino,$f_crea,$f_inicio,$f_termino,$n_pasajero,$precio,$valor_tipo_cambio,$tipo_cambio,$preciopesos,$pagospesos);
			$arr = array();
			$i=0; 
			while ($sentencia->fetch()) {
				$arr[$i]['id']=$id;
				$arr[$i]['id_us_crea']=$id_us_crea;
				$arr[$i]['id_cliente']=$id_cliente;
				$arr[$i]['tipo_cuenta']=$tipo_cuenta;
				$arr[$i]['destino']=$destino;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['f_inicio']=$f_inicio;
				$arr[$i]['f_termino']=$f_termino;
				$arr[$i]['n_pasajero']=$n_pasajero;
				$arr[$i]['precio']=$precio;
				$arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr[$i]['tipo_cambio']=$tipo_cambio;
				$arr[$i]['preciopesos']=$preciopesos;
				$arr[$i]['pagospesos']=$pagospesos;
				$i++;	
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	
	public function getPagosClientesbyID($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT a.id,a.id_us_crea,a.id_cliente,a.tipo_cuenta,a.destino,a.f_crea,a.f_inicio,a.f_termino,a.n_pasajero,a.precio,a.valor_tipo_cambio,a.tipo_cambio,if(a.tipo_cambio='DOLAR',(a.precio*a.valor_tipo_cambio),a.precio) as preciopesos,b.pagospesos FROM negocios as a LEFT JOIN(SELECT c.id_negocio,SUM(if(c.tipo_moneda='DOLAR',c.monto*d.valor_tipo_cambio,c.monto)) as pagospesos FROM pagos_negocio_cli as c LEFT JOIN negocios as d ON c.id_negocio=d.id GROUP BY c.id_negocio) as b ON b.id_negocio=a.id WHERE a.id_cliente=?;";
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$sentencia->bind_result($id,$id_us_crea,$id_cliente,$tipo_cuenta,$destino,$f_crea,$f_inicio,$f_termino,$n_pasajero,$precio,$valor_tipo_cambio,$tipo_cambio,$preciopesos,$pagospesos);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch()) {
				$arr[$i]['id']=$id;
				$arr[$i]['id_us_crea']=$id_us_crea;
				$arr[$i]['id_cliente']=$id_cliente;
				$arr[$i]['tipo_cuenta']=$tipo_cuenta;
				$arr[$i]['destino']=$destino;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['f_inicio']=$f_inicio;
				$arr[$i]['f_termino']=$f_termino;
				$arr[$i]['n_pasajero']=$n_pasajero;
				$arr[$i]['precio']=$precio;
				$arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr[$i]['tipo_cambio']=$tipo_cambio;
				$arr[$i]['preciopesos']=$preciopesos;
				$arr[$i]['pagospesos']=$pagospesos;
				$i++;				
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	public function servPaginas($id_cli,$desde,$id_neg,$destino,$tipo_cambio,$tipo_cuenta){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			$buscar="";
			
			if($id_neg!=""){
				$buscar=$buscar." id=".$id_neg." AND";
			}
			if($destino!=""){
				$buscar=$buscar." destino LIKE '%".$destino."%' AND";
			}
			if($tipo_cambio!="" && $tipo_cambio!="ambos"){
				$buscar=$buscar." tipo_cambio='".$tipo_cambio."' AND";
			}
			
			if($tipo_cuenta!="" && $tipo_cuenta!="ambos"){
				$buscar=$buscar." tipo_cuenta='".$tipo_cambio."' AND";
			}
			
			
			$sql = "SELECT id,f_crea,precio,tipo_cambio,valor_tipo_cambio,destino,tipo_cuenta,f_inicio,f_termino FROM negocios WHERE".$buscar."  id_cliente=? ORDER BY id ASC LIMIT 10 OFFSET ?;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ii",$id_cli,$desde);
			$sentencia->execute();
			
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	public function getServiciosbyIDcli($id_cli,$desde,$id_neg,$destino,$tipo_cambio,$tipo_cuenta){
		try{
			$conexion = Conectar::con();
			$buscar="";
			
			if($id_neg!=""){
				$buscar=$buscar." id=".$id_neg." AND";
			}
			if($destino!=""){
				$buscar=$buscar." destino LIKE '%".$destino."%' AND";
			}
			if($tipo_cambio!="" && $tipo_cambio!="ambos"){
				$buscar=$buscar." tipo_cambio='".$tipo_cambio."' AND";
			}
			
			if($tipo_cuenta!="" && $tipo_cuenta!="ambos"){
				$buscar=$buscar." tipo_cuenta='".$tipo_cuenta."' AND";
			}
			
			
			$sql = "SELECT id,f_crea,precio,tipo_cambio,valor_tipo_cambio,destino,tipo_cuenta,f_inicio,f_termino FROM negocios WHERE".$buscar."  id_cliente=? ORDER BY id ASC LIMIT 10 OFFSET ?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ii",$id_cli,$desde);
			$sentencia->execute();
			
			$sentencia->bind_result($id,$f_crea,$precio,$tipo_cambio,$valor_tipo_cambio,$destino,$tipo_cuenta,$f_inicio,$f_termino);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch()) {
				$arr[$i]['id']=$id;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['precio']=$precio;
				$arr[$i]['tipo_cambio']=$tipo_cambio;
				$arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr[$i]['destino']=$destino;
				$arr[$i]['tipo_cuenta']=$tipo_cuenta;
				$arr[$i]['f_inicio']=$f_inicio;
				$arr[$i]['f_termino']=$f_termino;
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	
	
	public function servPaginasCLI($id_cli,$id_neg,$destino,$tipo_cambio,$tipo_cuenta){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			$buscar="";
			
			if($id_neg!=""){
				$buscar=$buscar." id=".$id_neg." AND";
			}
			if($destino!=""){
				$buscar=$buscar." destino LIKE '%".$destino."%' AND";
			}
			if($tipo_cambio!="" && $tipo_cambio!="ambos"){
				$buscar=$buscar." tipo_cambio='".$tipo_cambio."' AND";
			}
			
			if($tipo_cuenta!="" && $tipo_cuenta!="ambos"){
				$buscar=$buscar." tipo_cuenta='".$tipo_cambio."' AND";
			}
			
			
			$sql = "SELECT id,f_crea,precio,tipo_cambio,valor_tipo_cambio,destino,tipo_cuenta,f_inicio,f_termino FROM negocios WHERE".$buscar."  id_cliente=? ORDER BY id ASC;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id_cli);
			$sentencia->execute();
			
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	public function getServiciosbyIDcliCLI($id_cli,$desde,$id_neg,$destino,$tipo_cambio,$tipo_cuenta){
		try{
			$conexion = Conectar::con();
			$buscar="";
			
			if($id_neg!=""){
				$buscar=$buscar." id=".$id_neg." AND";
			}
			if($destino!=""){
				$buscar=$buscar." destino LIKE '%".$destino."%' AND";
			}
			if($tipo_cambio!="" && $tipo_cambio!="ambos"){
				$buscar=$buscar." tipo_cambio='".$tipo_cambio."' AND";
			}
			
			if($tipo_cuenta!="" && $tipo_cuenta!="ambos"){
				$buscar=$buscar." tipo_cuenta='".$tipo_cuenta."' AND";
			}
			
			
			$sql = "SELECT id,f_crea,precio,tipo_cambio,valor_tipo_cambio,destino,tipo_cuenta,f_inicio,f_termino FROM negocios WHERE".$buscar."  id_cliente=? ORDER BY f_inicio DESC LIMIT 10 OFFSET ?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ii",$id_cli,$desde);
			$sentencia->execute();
			
			$sentencia->bind_result($id,$f_crea,$precio,$tipo_cambio,$valor_tipo_cambio,$destino,$tipo_cuenta,$f_inicio,$f_termino);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch()) {
				$arr[$i]['id']=$id;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['precio']=$precio;
				$arr[$i]['tipo_cambio']=$tipo_cambio;
				$arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr[$i]['destino']=$destino;
				$arr[$i]['tipo_cuenta']=$tipo_cuenta;
				$arr[$i]['f_inicio']=$f_inicio;
				$arr[$i]['f_termino']=$f_termino;
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	
	
	
	
	
	
	
	
	
	public function getNegociobyClienteID($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,destino,f_crea,f_inicio,f_termino,n_pasajero FROM negocios WHERE id_cliente=?;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$sentencia->bind_result($id,$destino,$f_crea,$f_inicio,$f_termino,$n_pasajero);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch()) {
				$arr[$i]['id']=$id;
				$arr[$i]['destino']=$destino;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['f_inicio']=$f_inicio;
				$arr[$i]['f_termino']=$f_termino;
				$arr[$i]['n_pasajero']=$n_pasajero;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	public function getPagosbyClienteID($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT a.id,a.monto,a.detalle,a.forma_pago,b.descripcion,b.valor,c.destino FROM pagos_serv as a LEFT JOIN servicios_negocios as b ON a.id_servicio=b.id LEFT JOIN negocios as c ON b.id_negocio=c.id WHERE c.id_cliente=?;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$sentencia->bind_result($id,$monto,$detalle,$forma_pago,$descripcion,$valor,$destino);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch()) {
				$arr[$i]['id']=$id;
				$arr[$i]['monto']=$monto;
				$arr[$i]['detalle']=$detalle;
				$arr[$i]['forma_pago']=$forma_pago;
				$arr[$i]['descripcion']=$descripcion;
				$arr[$i]['valor']=$valor;
				$arr[$i]['destino']=$destino;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	public function getContacto($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,id_cliente,id_us_crea,f_crea,nombre,cargo,fono,fono_movil,email,nota FROM contactos_clientes WHERE id_cliente=?;";

			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);	
			$sentencia->execute();
			$sentencia->bind_result($id,$id_cliente,$id_us_crea,$f_crea,$nombre,$cargo,$fono,$fono_movil,$email,$nota);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['id_cliente']=$id_cliente;
				$arr[$i]['id_us_crea']=$id_us_crea;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['cargo']=$cargo;
				$arr[$i]['fono']=$fono;
				$arr[$i]['fono_movil']=$fono_movil;
				$arr[$i]['email']=$email;
				$arr[$i]['nota']=$nota;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function creaContactoCli($datos){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			
			$sql = "INSERT INTO contactos_clientes(id_cliente,id_us_crea,nombre,cargo,fono,fono_movil,email,nota,f_crea) VALUES(?,?,?,?,?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("iisssssss",$datos['id_cliente'],$datos['id_us_crea'],$datos['nombre'],$datos['cargo'],$datos['fono'],$datos['fono_movil'],$datos['email'],$datos['nota'],$fec_crea);
			
			


			
			$sentencia->execute();

			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;
			}
	
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
		
	}
	
	public function borrarContactoCli($id){
		try{
			$sql = "DELETE FROM contactos_clientes WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	
}

class negocios extends Conectar{
	
	public function updtDescServ($id,$valor){
		try{
			$conexion = Conectar::con();
			$sql="UPDATE servicios_negocios set descripcion=? WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("si",$valor,$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function udtFPago($id,$fecha){
		try{
			$conexion = Conectar::con();
			$sql="UPDATE servicios_negocios set fecha_pago=? WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("si",$fecha,$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function udtFPagoClient($id,$fecha){
		try{
			$conexion = Conectar::con();
			$sql="UPDATE pagos_negocio_cli set f_deposito=? WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("si",$fecha,$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function borrarViaje($id){
		try{
			$sql = "DELETE FROM negocios WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function borrarViajeFull($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id FROM servicios_negocios WHERE id_negocio=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);	
			$sentencia->execute();
			$sentencia->bind_result($id_servicio);
			
			 while ($sentencia->fetch())
			 { 
				$conexion1 = Conectar::con();
				$sql1 = "SELECT id,id_servicio,forma_pago,id_cheque FROM pagos_serv WHERE id_servicio=?;";
				$sentencia1 = $conexion1->prepare($sql1);
				$sentencia1->bind_param("i",$id_servicio);	
				$sentencia1->execute();
				$sentencia1->bind_result($id_pago_serv,$id_servicio_pago,$forma_pago,$id_cheque);
				
				while ($sentencia1->fetch())
				{
					if($forma_pago=='CHEQUE_DIA' || $forma_pago=='CHEQUE_FECHA'){
						$conexion2 = Conectar::con();
						$sql2 = "DELETE FROM cheques WHERE id=? AND nom_tabla='pagos_serv' ;";
						$sentencia2 = $conexion2->prepare($sql2);
						$sentencia2->bind_param("i",$id_cheque);
						$sentencia2->execute();
						$conexion2->close();
						$sentencia2->close();
					}
				}
				
				$conexion1->close();
				$sentencia1->close();
			 }
			 
			$sql = "SELECT id FROM servicios_negocios WHERE id_negocio=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);	
			$sentencia->execute();
			$sentencia->bind_result($id_servicio);
			 
			 while ($sentencia->fetch())
			 { 
				$conexion2 = Conectar::con();
				$sql2 = "DELETE FROM pagos_serv WHERE id_servicio=?";
				$sentencia2 = $conexion2->prepare($sql2);
				$sentencia2->bind_param("i",$id_servicio);
				$sentencia2->execute();
				$conexion2->close();
				$sentencia2->close();
			 }
			 
			 
			$sql = "DELETE FROM servicios_negocios WHERE id_negocio=?";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			 
/////////////////BORRA PAGO DE CLIENTES//////////////////////////////////////////////////////
			$sql = "SELECT id,forma_pago,id_cheque FROM pagos_negocio_cli WHERE id_negocio=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);	
			$sentencia->execute();
			$sentencia->bind_result($id_pago,$forma_pago,$id_chequec);

			
			while ($sentencia->fetch())
			{
				if($forma_pago=='CHEQUE_DIA' || $forma_pago=='CHEQUE_FECHA'){
					$conexion2 = Conectar::con();
					$sql2 = "DELETE FROM cheques WHERE id=? AND nom_tabla='pagos_negocio_cli'";
					$sentencia2 = $conexion2->prepare($sql2);
					$sentencia2->bind_param("i",$id_chequec);
					$sentencia2->execute();
					$conexion2->close();
					$sentencia2->close();
				}
			}
			
			
			$sql = "DELETE FROM pagos_negocio_cli WHERE id_negocio=?";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
///////////////////////////////////////////////////////////////////////			
			$sql = "DELETE FROM negocios WHERE id=?";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
			$sentencia->close();
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function pagarDestinoCli($datos){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			$id_che='';
			$sql = "INSERT INTO pagos_negocio_cli(id_negocio,id_us_crea,fecha,monto,forma_pago,n_cheque,n_cuotas,cargo_transbank,total_cuota,tipo_moneda,n_comprobante,detalle,f_deposito) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("iisssssssssss",$datos['id_negocio'],$datos['id_us_crea'],$fec_crea,$datos['monto'],$datos['forma_pago'],$datos['n_cheque'],$datos['n_cuotas'],$datos['cargo_transbank'],$datos['total_cuota'],$datos['tipo_moneda'],$datos['n_comprobante'],$datos['detalle'],$datos['f_deposito']);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				$insert_id=$conexion->insert_id;
				if($datos['forma_pago']=='CHEQUE_DIA' || $datos['forma_pago']=='CHEQUE_FECHA'){
					$nom_tabla='pagos_negocio_cli';
					$estado='pendiente';
					$tipo_cheque='cobrar';
					$sql2 = "INSERT INTO cheques(id_us_crea,fecha_crea,id_tabla_aso,nom_tabla,rut_girador,nombre_girador,banco,n_cuenta,n_cheque,monto,fecha_cobro,estado,pax,tipo_cuenta,tipo_cheque) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
					$sentencia2 = $conexion->prepare($sql2);
					$sentencia2->bind_param("isissssssssssss",$datos['id_us_crea'],$fec_crea,$insert_id,$nom_tabla,$datos['rut_girador'],$datos['nombre_girador'],$datos['banco'],$datos['n_cuenta'],$datos['n_cheque'],$datos['monto'],$datos['fecha_cobro'],$estado,$datos['pax'],$datos['tipo_moneda'],$tipo_cheque);
					$sentencia2->execute();
				}
				
				if ($sentencia->errno) {
					return "fallo!!! " . $sentencia->error;
				}else{
					$id_che=$conexion->insert_id;
					$sql="UPDATE pagos_negocio_cli set id_cheque=? WHERE id=?;";
					$sentencia = $conexion->prepare($sql);
					$sentencia->bind_param("ii",$id_che,$insert_id);
					$sentencia->execute();
				}
				
				$tabla='pagos_negocio_cli';
				$tipo='INGRESO';
				$sql = "INSERT INTO comprobantes(tipo,id_tabla,tabla) VALUES(?,?,?);";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("sis",$tipo,$insert_id,$tabla);
				$sentencia->execute();
				
				
				return array('id'=>$insert_id,'id_cheque'=>$id_che);
				exit();
			}
			
			$conexion->close();
            $sentencia->close();
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	public function borrarPagoClientes($id){
		try{
			$id_cheque='';
			$conexion = Conectar::con();
			$sql = "select id_cheque FROM pagos_negocio_cli WHERE id=? limit 1;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$sentencia->bind_result($n_cheque);
			 
			while ($sentencia->fetch()) {
				$id_cheque=$n_cheque;
			}
			
			
			if($id_cheque!='' || $id_cheque!=0){
				$sql = "DELETE FROM cheques WHERE id=? AND nom_tabla='pagos_negocio_cli'";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("i",$id_cheque);
				$sentencia->execute();
			}


			$sql = "DELETE FROM pagos_negocio_cli WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$retorno=0;

			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				$retorno=$sentencia->affected_rows;
			}
			
			return $retorno;
			
			$conexion->close();
			$conexion2->close();
			$sentencia->close();
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}



	public function crearNegocio($datos){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			$sql = "INSERT INTO negocios(id_us_crea,id_cliente,tipo_cuenta,destino,precio,tipo_cliente,f_crea,f_inicio,f_termino,n_pasajero,nota,valor_tipo_cambio,tipo_cambio,f_ingreso_neg,nombre_pasa_pri,rut_pasa_pri,pasaporte_pasa_pri,f_nac_pasa_pri,add_pasa_pri,privado) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("iissssssssssssssssss",$datos['vendedor_id'],$datos['id_cliente'],$datos['cuenta'],$datos['destino'],$datos['pre_destino'],$datos['tipo_cliente'],$fec_crea,$datos['fini'],$datos['fterm'],$datos['npasajeros'],$datos['observaciones'],$datos['tipo_cambio_valor'],$datos['tipo_cambio'],$datos['fnegocio'],$datos['nom_pasa_pri'],$datos['rut_pasa_pri'],$datos['pas_pasa_pri'],$datos['fnac_pasa_pri'],$datos['adi_pasa_pri'],$datos['privado']);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				header("Location:viajes_det.php?id=".$conexion->insert_id);
				exit();
			}
			
			$conexion->close();
            $sentencia->close();
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}

	public function getNegocio($id){
		try{
			$conexion = Conectar::con();
			$sql = "select a.privado,a.nombre_pasa_pri,a.rut_pasa_pri,a.pasaporte_pasa_pri,a.f_nac_pasa_pri,a.add_pasa_pri,a.id,a.id_us_crea,a.id_cliente,a.tipo_cuenta,a.destino,a.precio,a.tipo_cliente,a.f_crea,a.f_inicio,a.f_termino,a.n_pasajero,a.nota,a.valor_tipo_cambio,a.tipo_cambio,b.nombre as nombre_cliente,b.apepat as apepat_cliente,b.apemat as apemat_cliente,b.rut as rut_cliente,c.nombre as nombre_vendedor,c.apepat as apepat_vendedor,c.apemat as apemat_vendedor,c.rut as rut_vendedor,a.f_ingreso_neg from negocios as a left join clientes as b on a.id_cliente=b.id left join usuarios as c on a.id_us_crea=c.id WHERE a.id=? limit 1;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$sentencia->bind_result($privado,$nombre_pasa_pri,$rut_pasa_pri,$pasaporte_pasa_pri,$f_nac_pasa_pri,$add_pasa_pri,$id,$id_us_crea,$id_cliente,$tipo_cuenta,$destino,$precio,$tipo_cliente,$f_crea,$f_inicio,$f_termino,$n_pasajero,$nota,$valor_tipo_cambio,$tipo_cambio,$nombre_cliente,$apepat_cliente,$apemat_cliente,$rut_cliente,$nombre_vendedor,$apepat_vendedor,$apemat_vendedor,$rut_vendedor,$f_ingreso_neg);
			$arr = array();
			 while ($sentencia->fetch()) {
				$arr['id']=$id;
				$arr['id_us_crea']=$id_us_crea;
				$arr['id_cliente']=$id_cliente;
				$arr['tipo_cuenta']=$tipo_cuenta;
				$arr['destino']=$destino;
				$arr['precio']=$precio;
				$arr['tipo_cliente']=$tipo_cliente;
				$arr['f_crea']=$f_crea;
				$arr['f_inicio']=$f_inicio;
				$arr['f_termino']=$f_termino;
				$arr['n_pasajero']=$n_pasajero;
				$arr['nota']=$nota;
				$arr['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr['tipo_cambio']=$tipo_cambio;
				$arr['nombre_cliente']=$nombre_cliente;
				$arr['apepat_cliente']=$apepat_cliente;
				$arr['apemat_cliente']=$apemat_cliente;
				$arr['rut_cliente']=$rut_cliente;
				$arr['nombre_vendedor']=$nombre_vendedor;
				$arr['apepat_vendedor']=$apepat_vendedor;
				$arr['apemat_vendedor']=$apemat_vendedor;
				$arr['rut_vendedor']=$rut_vendedor;
				$arr['f_ingreso_neg']=$f_ingreso_neg;

				$arr['nombre_pasa_pri']=$nombre_pasa_pri;
				$arr['rut_pasa_pri']=$rut_pasa_pri;
				$arr['pasaporte_pasa_pri']=$pasaporte_pasa_pri;
				$arr['f_nac_pasa_pri']=$f_nac_pasa_pri;
				$arr['add_pasa_pri']=$add_pasa_pri;
				$arr['privado']=$privado;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	public function actualizaNegocio($datos){
		try{
			$conexion = Conectar::con();
			$sql="UPDATE negocios SET tipo_cuenta=?,tipo_cliente=?,destino=?,precio=?,f_inicio=?,f_termino=?,n_pasajero=?,nota=?,f_ingreso_neg=?,nombre_pasa_pri=?,rut_pasa_pri=?,pasaporte_pasa_pri=?,f_nac_pasa_pri=?,add_pasa_pri=?,tipo_cambio=?,privado=? WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ssssssssssssssssi",$datos['cuenta'],$datos['tipo_cliente'],$datos['destino'],$datos['precio'],$datos['fini'],$datos['fterm'],$datos['npasajeros'],$datos['observaciones'],$datos['fnegocio'],$datos['nom_pasa_pri'],$datos['rut_pasa_pri'],$datos['pas_pasa_pri'],$datos['fnac_pasa_pri'],$datos['adi_pasa_pri'],$datos['tipo_cambio'],$datos['privado'],$datos['cod_viaje']);
			$sentencia->execute();
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}	
	
	public function getTiposDeCambio(){
		try{
			$conexion = Conectar::con();

			$sql = "SELECT id,CAST(avg(efectivo) AS UNSIGNED),CAST(avg(tarjeta) AS UNSIGNED),CONCAT(YEAR(fecha),'-',LPAD(MONTH(fecha),2,'0')) AS fecha FROM tipos_cambios_diarios GROUP BY MONTH(fecha) ORDER BY fecha DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			
			$sentencia->bind_result($id,$efectivo,$tarjeta,$fecha);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['efectivo']=$efectivo;
				$arr[$i]['tarjeta']=$tarjeta;
				$arr[$i]['fecha']=$fecha; 
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
			
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }	
	}
	
	public function cambiosUltimoMes($añomes){
		try{
			$conexion = Conectar::con();

			$sql = "SELECT id,fecha,efectivo,tarjeta FROM tipos_cambios_diarios WHERE fecha  LIKE '".$añomes."%' ORDER BY fecha ASC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			
			$sentencia->bind_result($id,$fecha,$efectivo,$tarjeta);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['fecha']=$fecha;
				$arr[$i]['efectivo']=$efectivo;
				$arr[$i]['tarjeta']=$tarjeta;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function verificaTipoCambio($fecha){
		try{
			if($fecha=="" || $fecha== null || $fecha == "null"){
				return "error";
			}else{
				$conexion = Conectar::con();
				$sql = "SELECT * FROM tipos_cambios_diarios WHERE fecha=?;";
				
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("s",$fecha);		
				$sentencia->execute();
				
				$sentencia->store_result();
				return $sentencia->num_rows;
				
				$conexion->close();
				$sentencia->close();

			}		
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function modificaCambio($fecha_tipoc,$efectivo_tipoc,$tarjeta_tipoc){
		try{
			$conexion = Conectar::con();
			
			$sql = "SELECT * FROM tipos_cambios_diarios WHERE fecha=?;";
				
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("s",$fecha_tipoc);		
			$sentencia->execute();
			$sentencia->store_result();
			
			
			if($sentencia->num_rows>0){
				$sql="UPDATE tipos_cambios_diarios set efectivo=?,tarjeta=? WHERE fecha=?";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("sss",$efectivo_tipoc,$tarjeta_tipoc,$fecha_tipoc);
			}else{
				$sql = "INSERT INTO tipos_cambios_diarios (fecha,efectivo,tarjeta) VALUES(?,?,?);";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("sss",$fecha_tipoc,$efectivo_tipoc,$tarjeta_tipoc);
			}
				
			
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return "1";// retorna el id creado
			}
			
			$conexion->close();
            $sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function getValorDolarDia(){
		try{
			$fecha = date('Y-m-d');
			$conexion = Conectar::con();
			$sql = "SELECT efectivo,tarjeta FROM tipos_cambios_diarios WHERE fecha=? limit 1;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("s",$fecha);	
			$sentencia->execute();
			
			$sentencia->bind_result($efectivo,$tarjeta);
			$arr = array();
			
			 while ($sentencia->fetch())
			 {
				$arr['efectivo']=$efectivo;
				$arr['tarjeta']=$tarjeta;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
	
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function getProveedores(){
		try{
			$fecha = date('Y-m-d');
			$conexion = Conectar::con();
			$sql = "SELECT id,nombre,rut,cambiodolar,cambiopeso FROM proveedores WHERE estado=1 ORDER BY nombre ASC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			
			$sentencia->bind_result($id,$nombre,$rut,$cambiodolar,$cambiopeso);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['rut']=$rut;
				$arr[$i]['cambiodolar']=$cambiodolar;
				$arr[$i]['cambiopeso']=$cambiopeso;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function getServicios($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,descripcion,valor,cambiodolar,cambiopeso,incluyeiva,confirmacion FROM proveedores_servicios WHERE id_proveedor=? ORDER BY id ASC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);	
			$sentencia->execute();
			
			$sentencia->bind_result($id,$descripcion,$valor,$cambiodolar,$cambiopeso,$incluyeiva,$confirmacion);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['descripcion']=$descripcion;
				$arr[$i]['valor']=$valor;
				$arr[$i]['cambiodolar']=$cambiodolar;
				$arr[$i]['cambiopeso']=$cambiopeso;
				$arr[$i]['incluyeiva']=$incluyeiva;
				$arr[$i]['confirmacion']=$confirmacion;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
	
	public function creaServicioNegocio($datos){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			$sql = "INSERT INTO servicios_negocios(id_negocio,id_proveedor,id_us_crea,f_crea,descripcion,valor,tipo_cambio,valor_tipo_cambio,incluye_iva,fecha_pago) VALUES(?,?,?,?,?,?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("iiisssssss",$datos['id_negocio'],$datos['id_proveedor'],$datos['id_us_crea'],$fec_crea,$datos['descripcion'],$datos['valor'],$datos['tipo_cambio'],$datos['valor_tipo_cambio'],$datos['incluye_iva'],$datos['fecha_pago']);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;// retorna el id creado
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function getPagosCli($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT a.id,a.id_us_crea,a.fecha,a.monto,a.forma_pago,a.n_cheque,a.n_cuotas,a.cargo_transbank,a.total_cuota,a.tipo_moneda,b.nombre,b.apepat,b.rut,a.f_deposito,c.id,a.n_comprobante,a.detalle FROM pagos_negocio_cli as a LEFT JOIN usuarios as b ON a.id_us_crea=b.id LEFT JOIN cheques as c ON a.id_cheque=c.id WHERE a.id_negocio=? ORDER BY a.id ASC;";
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);	
			$sentencia->execute();
			
			$sentencia->bind_result($id,$id_us_crea,$fecha,$monto,$forma_pago,$n_cheque,$n_cuotas,$cargo_transbank,$total_cuota,$tipo_moneda,$nombre,$apepat,$rut,$f_deposito,$id_cheque,$n_comprobante,$detalle);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch())
			 {
				  $arr[$i]['id']=$id;
				  $arr[$i]['id_us_crea']=$id_us_crea;
				  $arr[$i]['fecha']=$fecha;
				  $arr[$i]['monto']=$monto;
				  $arr[$i]['forma_pago']=$forma_pago;
				  $arr[$i]['n_cheque']=$n_cheque;
				  $arr[$i]['n_cuotas']=$n_cuotas;
				  $arr[$i]['cargo_transbank']=$cargo_transbank;
				  $arr[$i]['total_cuota']=$total_cuota;
				  $arr[$i]['tipo_moneda']=$tipo_moneda;
				  $arr[$i]['nombre']=$nombre;
				  $arr[$i]['apepat']=$apepat;
				  $arr[$i]['rut']=$rut;
				  $arr[$i]['f_deposito']=$f_deposito;
				  $arr[$i]['id_cheque']=$id_cheque;
				  $arr[$i]['n_comprobante']=$n_comprobante;
				  $arr[$i]['detalle']=$detalle;
				  
				  $i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
	public function getServiciosNeg($id){
		try{
			$conexion = Conectar::con();

			$sql = "SELECT a.id,a.id_negocio,a.id_proveedor,a.id_us_crea,a.f_crea,a.descripcion,a.valor,a.tipo_cambio,a.valor_tipo_cambio,a.incluye_iva,b.nombre,b.rut,c.pago,a.fecha_pago FROM servicios_negocios as a LEFT JOIN proveedores as b ON a.id_proveedor=b.id LEFT JOIN (SELECT aa.id_servicio,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as c ON c.id_servicio = a.id WHERE a.id_negocio=? ORDER BY a.id ASC;";
			
			//$sql = "SELECT a.id,a.id_negocio,b.nombre,b.rut,a.descripcion,a.tipo_cambio,a.forma_pago,a.valor,a.f_crea,c.pago FROM servicios_negocios as a LEFT JOIN proveedores as b ON a.id_proveedor=b.id LEFT JOIN (SELECT id,id_servicio,SUM(monto) as pago FROM pagos_serv GROUP BY id_servicio) as c ON c.id_servicio = a.id WHERE a.id_negocio=? ORDER BY a.id ASC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);	
			$sentencia->execute();
			
			$sentencia->bind_result($id,$id_negocio,$id_proveedor,$id_us_crea,$f_crea,$descripcion,$valor,$tipo_cambio,$valor_tipo_cambio,$incluye_iva,$nombre,$rut,$pago,$fecha_pago);

			$arr = array();
			$i=0;
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['id_negocio']=$id_negocio;
				$arr[$i]['id_proveedor']=$id_proveedor;
				$arr[$i]['id_us_crea']=$id_us_crea;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['descripcion']=$descripcion;
				$arr[$i]['valor']=$valor;
				$arr[$i]['tipo_cambio']=$tipo_cambio;
				$arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr[$i]['incluye_iva']=$incluye_iva;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['rut']=$rut;
				$arr[$i]['pago']=$pago;
				$arr[$i]['f_pago']=$fecha_pago;
				
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function borrarServNego($id){
		try{
			$sql = "DELETE FROM servicios_negocios WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function getPasajeros($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,f_nac,nombre,rut,nota FROM pasajeros WHERE id_negocio=? ORDER BY id ASC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);	
			$sentencia->execute();
			
			$sentencia->bind_result($id,$f_nac,$nombre,$rut,$nota);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['f_nac']=$f_nac;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['rut']=$rut;
				$arr[$i]['nota']=$nota;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function borrarPasajero($id){
		try{
			$sql = "DELETE FROM pasajeros WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function borrarTodosPasajeros($id){
		try{
			$sql = "DELETE FROM pasajeros WHERE id_negocio=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function crearPasajero($datos){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			$sql = "INSERT INTO pasajeros(id_negocio,f_nac,nombre,rut,nota) VALUES(?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("issss",$datos['id_viaje'],$datos['f_nac'],$datos['nombre'],$datos['rut'],$datos['nota']);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;// retorna el id creado
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function actualizarPasajero($datos){
		try{
			$conexion = Conectar::con();
			$sql="UPDATE pasajeros SET id_negocio=?,f_nac=?,nombre=?,rut=?,nota=? WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("issssi",$datos['id_viaje'],$datos['f_nac'],$datos['nombre'],$datos['rut'],$datos['nota'],$datos['id']);
			$sentencia->execute();
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function getNotas($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,id_negocio,nota,fec_crea FROM notas WHERE id_negocio=? ORDER BY id ASC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);	
			$sentencia->execute();
			
			$sentencia->bind_result($id,$id_negocio,$nota,$fec_crea);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['id_negocio']=$id_negocio;
				$arr[$i]['nota']=$nota;
				$arr[$i]['fec_crea']=$fec_crea;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function crearNota($id_negocio,$nota,$id_us){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			$sql = "INSERT INTO notas(id_negocio,id_us_crea,nota,fec_crea) VALUES(?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("iiss",$id_negocio,$id_us,$nota,$fec_crea);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;// retorna el id creado
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	
	public function paginas($codigo,$rut,$nombre,$destino,$tipocuenta,$fini,$ffin,$pasajero,$id_usuario){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			$buscar ="";
			
			if($codigo!=""){
				$buscar = $buscar."f.id=".$codigo." AND ";
			}
			
			if($rut!=""){
				$buscar = " (".$buscar." b.nombre LIKE '%".$rut."%' OR b.apepat LIKE '%".$rut."%' ) AND ";
			}
			
			if($nombre!=""){
				$buscar = $buscar."a.id=".$nombre." AND ";
			}
			
			if($destino!=""){
				$buscar = $buscar."a.destino LIKE '%".$destino."%' AND ";
			}
			
			if($pasajero!=""){
				$buscar = $buscar."a.nombre_pasa_pri LIKE '%".$pasajero."%' AND ";
			}
			
			if($tipocuenta!="" && $tipocuenta!="ambos" ){
				$buscar = $buscar."a.tipo_cuenta='".$tipocuenta."' AND ";
			}
			
			if($fini!='' && $ffin!=''){
				$buscar = $buscar."a.f_crea BETWEEN '".$fini."' AND '".$ffin."' AND ";
			}
			
			if($fini=='' && $ffin!=''){
				$buscar = $buscar."a.f_crea='".$ffin."' AND ";
			}
			
			if($fini!='' && $ffin==''){
				$buscar = $buscar."a.f_crea='".$fini."' AND ";
			}
			
			if($id_usuario!=''){
				$buscar = $buscar."a.id_us_crea=".$id_usuario." AND ";
			}
			
			//$sql = "SELECT a.id_us_crea,a.privado,a.nombre_pasa_pri,f.nombre,f.apepat,a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,c.contar_serv,d.contar_pago FROM negocios as a LEFT JOIN usuarios as f ON a.id_us_crea=f.id LEFT JOIN clientes as b ON a.id_cliente=b.id LEFT JOIN (SELECT id_negocio,count(id) as contar_serv FROM servicios_negocios GROUP BY id_negocio) as c ON c.id_negocio = a.id LEFT JOIN (SELECT id_negocio,count(id) as contar_pago FROM pagos_negocio_cli GROUP BY id_negocio) as d ON d.id_negocio = a.id WHERE ".$buscar." a.id is not NULL  GROUP BY a.id ORDER BY a.id DESC;";
			$sql = "SELECT a.id_us_crea,a.privado,a.nombre_pasa_pri,a.id,f.nombre,f.apepat,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_inicio,if(a.tipo_cambio='DOLAR',a.precio*a.valor_tipo_cambio,a.precio) as precio_viaje,e.valor_servicios,c.pago_servicios,d.pago_cliente FROM negocios as a LEFT JOIN usuarios as f ON a.id_us_crea=f.id LEFT JOIN clientes as b ON a.id_cliente=b.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY bb.id_negocio) as c ON c.id_negocio = a.id LEFT JOIN (SELECT aa.id_negocio,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_cliente FROM pagos_negocio_cli as aa LEFT JOIN negocios as bb ON aa.id_negocio=bb.id GROUP BY aa.id_negocio) as d ON d.id_negocio = a.id LEFT JOIN (SELECT id_negocio,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id_negocio) as e ON e.id_negocio = a.id WHERE ".$buscar."  a.id is not NULL GROUP BY a.id,e.id_negocio,c.id_negocio,d.id_negocio ORDER BY a.id DESC;";
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}

	public function getNegocios($desde,$codigo,$rut,$nombre,$destino,$tipocuenta,$fini,$ffin,$pasajero,$id_usuario){
		try{
			$conexion = Conectar::con();
			$buscar ="";
			
			if($codigo!=""){
				$buscar = $buscar."f.id=".$codigo." AND ";
			}
			
			if($rut!=""){
				$buscar = " (".$buscar." b.nombre LIKE '%".$rut."%' OR b.apepat LIKE '%".$rut."%' ) AND ";
			}
			
			if($nombre!=""){
				$buscar = $buscar."a.id=".$nombre." AND ";
			}
			
			if($destino!=""){
				$buscar = $buscar."a.destino LIKE '%".$destino."%' AND ";
			}
			
			if($pasajero!=""){
				$buscar = $buscar."a.nombre_pasa_pri LIKE '%".$pasajero."%' AND ";
			}
			
			if($tipocuenta!="" && $tipocuenta!="ambos" ){
				$buscar = $buscar."a.tipo_cuenta='".$tipocuenta."' AND ";
			}
			
			if($fini!='' && $ffin!=''){
				$buscar = $buscar."a.f_inicio BETWEEN '".$fini."' AND '".$ffin."' AND ";
			}
			
			if($fini=='' && $ffin!=''){
				$buscar = $buscar."a.f_inicio='".$ffin."' AND ";
			}
			
			if($fini!='' && $ffin==''){
				$buscar = $buscar."a.f_termino='".$fini."' AND ";
			}
			
			if($id_usuario!=''){
				$buscar = $buscar."a.id_us_crea=".$id_usuario." AND ";
			}
			
			
			//$sql = "SELECT f.nombre,f.apepat,a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,c.contar_serv,d.contar_pago FROM negocios as a LEFT JOIN usuarios as f ON a.id_us_crea=f.id LEFT JOIN clientes as b ON a.id_cliente=b.id LEFT JOIN (SELECT id_negocio,count(id) as contar_serv FROM servicios_negocios GROUP BY id_negocio) as c ON c.id_negocio = a.id LEFT JOIN (SELECT id_negocio,count(id) as contar_pago FROM pagos_negocio_cli GROUP BY id_negocio) as d ON d.id_negocio = a.id WHERE ".$buscar." a.id is not NULL ORDER BY a.id DESC LIMIT 10 OFFSET ?;";
			
			$sql = "SELECT a.id_us_crea,a.privado,a.nombre_pasa_pri,a.id,f.nombre,f.apepat,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_inicio,if(a.tipo_cambio='DOLAR',a.precio*a.valor_tipo_cambio,a.precio) as precio_viaje,e.valor_servicios,c.pago_servicios,d.pago_cliente FROM negocios as a LEFT JOIN usuarios as f ON a.id_us_crea=f.id LEFT JOIN clientes as b ON a.id_cliente=b.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY bb.id_negocio) as c ON c.id_negocio = a.id LEFT JOIN (SELECT aa.id_negocio,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_cliente FROM pagos_negocio_cli as aa LEFT JOIN negocios as bb ON aa.id_negocio=bb.id GROUP BY aa.id_negocio) as d ON d.id_negocio = a.id LEFT JOIN (SELECT id_negocio,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id_negocio) as e ON e.id_negocio = a.id WHERE ".$buscar."  a.id is not NULL GROUP BY a.id,e.id_negocio,c.id_negocio,d.id_negocio ORDER BY a.id DESC LIMIT 10 OFFSET ?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$desde);	
			$sentencia->execute();
			
			//$id,$nombre,$apepat,$id,$nombre,$apepat,$rut,$destino,$tipo_cuenta,$tipo_cliente,$f_crea,$precio_viaje,$valor_servicios,$pago_servicios,$pago_cliente
			$sentencia->bind_result($id_us_crea,$privado,$nombre_pasa_pri,$id,$nomusu,$apeusu,$nombre,$apepat,$rut,$destino,$tipo_cuenta,$tipo_cliente,$f_inicio,$precio_viaje,$valor_servicios,$pago_servicios,$pago_cliente);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['apepat']=$apepat;
				$arr[$i]['rut']=$rut;
				$arr[$i]['destino']=$destino;
				$arr[$i]['tipo_cuenta']=$tipo_cuenta;
				$arr[$i]['tipo_cliente']=$tipo_cliente;
				$arr[$i]['f_inicio']=$f_inicio;
				$arr[$i]['nomusu']=$nomusu;
				$arr[$i]['apeusu']=$apeusu;
				$arr[$i]['precio_viaje']=$precio_viaje;
				$arr[$i]['valor_servicios']=$valor_servicios;
				$arr[$i]['pago_servicios']=$pago_servicios;
				$arr[$i]['pago_cliente']=$pago_cliente;
				$arr[$i]['nombre_pasa_pri']=$nombre_pasa_pri;
				$arr[$i]['privado']=$privado;
				$arr[$i]['id_us_crea']=$id_us_crea;
				
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function GetVend(){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,nombre,apepat FROM usuarios ORDER BY id ASC";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			
			$sentencia->bind_result($id,$nombre,$apepat);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['apepat']=$apepat;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
			
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
	
	
	public function getPagoServ($id){
		try{
			$conexion = Conectar::con();
			//$sql='SELECT a.id,a.id_negocio,a.id_proveedor,a.f_crea,a.descripcion,a.valor,a.tipo_cambio,a.valor_tipo_cambio_efectivo,a.valor_tipo_cambio_tarjeta,a.incluye_iva,a.confirmacion,a.esta_confirm,b.nombre,b.rut FROM servicios_negocios as a LEFT JOIN proveedores as b ON a.id_proveedor=b.id WHERE a.id=?;';
			
			$sql='SELECT a.fecha_pago,a.id,a.id_negocio,a.id_proveedor,a.id_us_crea,a.f_crea,a.descripcion,a.valor,a.tipo_cambio,a.valor_tipo_cambio,a.incluye_iva,b.nombre,b.rut FROM servicios_negocios as a LEFT JOIN proveedores as b ON a.id_proveedor=b.id WHERE a.id=?;';
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			
			$sentencia->bind_result($fecha_pago,$id,$id_negocio,$id_proveedor,$id_us_crea,$f_crea,$descripcion,$valor,$tipo_cambio,$valor_tipo_cambio,$incluye_iva,$nombre,$rut);
			$arr = array();
			 while ($sentencia->fetch()) {
				$arr['id']=$id;
				$arr['id_negocio']=$id_negocio;
				$arr['id_proveedor']=$id_proveedor;
				$arr['id_us_crea']=$id_us_crea;
				$arr['f_crea']=$f_crea;
				$arr['descripcion']=$descripcion;
				$arr['valor']=$valor;
				$arr['tipo_cambio']=$tipo_cambio;
				$arr['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr['incluye_iva']=$incluye_iva;
				$arr['nombre_prov']=$nombre;
				$arr['rut_prov']=$rut;
				$arr['fecha_pago']=$fecha_pago;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	public function getMontosPago($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT if(a.id_cheque=0,'',a.id_cheque) as id_cheque,a.n_cheque,a.f_deposito,a.detalleefe,a.fecha_pago,a.id,a.id_servicio,b.nombre,b.apepat,b.rut,a.fecha,a.monto,c.valor_tipo_cambio,a.detalle,a.tipo_moneda,a.voucher,a.forma_pago FROM pagos_serv as a LEFT JOIN usuarios as b on a.id_us_crea=b.id LEFT JOIN servicios_negocios as  c ON a.id_servicio=c.id WHERE id_servicio=? ORDER BY id DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);	
			$sentencia->execute();

			$sentencia->bind_result($id_cheque,$n_cheque,$f_deposito,$detalleefe,$fecha_pago,$id,$id_servicio,$nombre,$apepat,$rut,$fecha,$monto,$valor_tipo_cambio,$detalle,$tipo_moneda,$voucher,$forma_pago);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['id_servicio']=$id_servicio;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['apepat']=$apepat;
				$arr[$i]['rut']=$rut;
				$arr[$i]['fecha']=$fecha;
				$arr[$i]['monto']=$monto;
				$arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr[$i]['detalle']=$detalle;
				$arr[$i]['tipo_moneda']=$tipo_moneda;
				$arr[$i]['voucher']=$voucher;
				$arr[$i]['forma_pago']=$forma_pago;
				$arr[$i]['fecha_pago']=$fecha_pago;
				$arr[$i]['detalleefe']=$detalleefe;
				$arr[$i]['id_cheque']=$id_cheque;
				$arr[$i]['f_deposito']=$f_deposito;
				$arr[$i]['n_cheque']=$n_cheque;
				
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function borrarPagoProv($id){
		try{
			$id_cheque='';
			$conexion = Conectar::con();
			$sql = "select id_cheque FROM pagos_serv WHERE id=? limit 1;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$sentencia->bind_result($n_cheque);
			
			while ($sentencia->fetch()) {
				$id_cheque=$n_cheque;
			}
			
			
			if($id_cheque!='' || $id_cheque!=0){
				$sql = "DELETE FROM cheques WHERE id=? AND nom_tabla='pagos_serv'";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("i",$id_cheque);
				$sentencia->execute();
			}
			
			$sql = "DELETE FROM pagos_serv WHERE id=?";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$retorno=0;

			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				$retorno=$sentencia->affected_rows;
			}
			
			return $retorno;
			
			$conexion->close();
			$conexion2->close();
			$sentencia->close();
			
			/*$sql = "DELETE FROM pagos_serv WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}*/
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function anadirPagoServicio($datos){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			$id_cheque="";
			$nom_tabla="pagos_serv";
			$estado='emitido';
			$tipo_cheque='girado';
			$id_tabla_aso="";
			
			$sql = "INSERT INTO pagos_serv(id_servicio,id_us_crea,fecha,monto,detalle,tipo_moneda,forma_pago,n_cheque,fecha_pago,detalleefe,f_deposito) VALUES(?,?,?,?,?,?,?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("iisssssssss",$datos['id_servicio'],$datos['id_us_crea'],$fec_crea,$datos['monto'],$datos['detalle'],$datos['tipo_moneda'],$datos['forma_pago'],$datos['n_cheque'],$datos['fecha_pago'],$datos['detalle_efe'],$datos['f_deposito']);
			$sentencia->execute();
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				$id_tabla_aso=$conexion->insert_id;// retorna el id creado
			}
			

			
			if($datos['forma_pago']=='CHEQUE_DIA' || $datos['forma_pago']=='CHEQUE_FECHA'){
				
				$rutgirador='76.006.128-K';
				$nombre_girador='EMPRESA DE TURISMO CHILETOURS LTDA.';
				$banco='BANCO DE CHILE';
				
				if($datos['tipo_cuenta']=='DOLAR'){
					$n_cuenta='5-159-22041-00';	
				}else{
					$n_cuenta='159-22041-06';
				}
				$pax='';
				
				$sql = "INSERT INTO cheques(id_us_crea,fecha_crea,id_tabla_aso,nom_tabla,rut_girador,nombre_girador,banco,n_cuenta,n_cheque,monto,fecha_cobro,estado,pax,tipo_cuenta,tipo_cheque) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("isissssssssssss",$datos['id_us_crea'],$fec_crea,$id_tabla_aso,$nom_tabla,$rutgirador,$nombre_girador,$banco,$n_cuenta,$datos['n_cheque'],$datos['monto'],$datos['fecha_cobro'],$estado,$pax,$datos['tipo_cuenta'],$tipo_cheque);
				$sentencia->execute();
				if ($sentencia->errno) {
					return "fallo!!! " . $sentencia->error;
				}else {
					$id_cheque=$conexion->insert_id;// retorna el id creado
				}
			}
			
			
			$sql="UPDATE pagos_serv SET id_cheque=? WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ii",$id_cheque,$id_tabla_aso);
			$sentencia->execute();
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	array('id'=>$id_tabla_aso,'id_cheque'=>$id_cheque);
			}
			
			$conexion->close();
            $sentencia->close();	
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
}

class configuracion extends Conectar{
	public function getPerfiles(){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,nombre,roles FROM perfiles ORDER BY id DESC;";
			$sentencia = $conexion->prepare($sql);	
			$sentencia->execute();

			$sentencia->bind_result($id,$nombre,$roles);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['roles']=$roles;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function getPerfilesUsuarios(){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id_perfil FROM usuarios GROUP BY id_perfil;";
			$sentencia = $conexion->prepare($sql);	
			$sentencia->execute();

			$sentencia->bind_result($id_perfil);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id_perfil']=$id_perfil;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function actPerfil($id,$nombre,$roles){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			$sql = "UPDATE perfiles SET nombre=?,roles=? WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ssi",$nombre,$roles,$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;// retorna el id creado
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function creaPerfil($nombre,$roles){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			$sql = "INSERT INTO perfiles(nombre,roles) VALUES(?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("ss",$nombre,$roles);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;// retorna el id creado
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function borrarPerfil($id){
		try{
			$sql = "DELETE FROM perfiles WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	
	public function getEmpresa(){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,nombre,contenido,orden FROM datos_empresa ORDER BY orden ASC;";
			$sentencia = $conexion->prepare($sql);	
			$sentencia->execute();

			$sentencia->bind_result($id,$nombre,$contenido,$orden);
			$arr = array();
			$i=0;
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['contenido']=$contenido;
				$arr[$i]['orden']=$orden;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function creaEmpresaDato($id_emp,$nombre,$contenido,$orden){
		try{
			$conexion = Conectar::con();

			if($id_emp!=""){
				$sql="UPDATE datos_empresa set nombre=?,contenido=?,orden=? WHERE id=?;";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("sssi",$nombre,$contenido,$orden,$id_emp);
			
			}else{
				$sql = "INSERT INTO datos_empresa(nombre,contenido,orden) VALUES(?,?,?);";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("sss",$nombre,$contenido,$orden);
			}

			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return $conexion->insert_id;// retorna el id creado
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function borrarEmpresaDato($id){
		try{
			$sql = "DELETE FROM datos_empresa WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function getUsuario($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,id_perfil,estado,f_creacion,nombre,apepat,apemat,email,genero,rut,f_nacimiento,fono_fijo,fono_movil,pais,ciudad,comuna,direccion FROM usuarios WHERE id=? LIMIT 1;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);	
			$sentencia->execute();

			$sentencia->bind_result($id,$id_perfil,$estado,$f_creacion,$nombre,$apepat,$apemat,$email,$genero,$rut,$f_nacimiento,$fono_fijo,$fono_movil,$pais,$ciudad,$comuna,$direccion);
			$arr = array();
			
			 while ($sentencia->fetch())
			 {
				$arr['id']=$id;
				$arr['id_perfil']=$id_perfil;
				$arr['estado']=$estado;
				$arr['f_creacion']=$f_creacion;
				$arr['nombre']=$nombre;
				$arr['apepat']=$apepat;
				$arr['apemat']=$apemat;
				$arr['email']=$email;
				$arr['genero']=$genero;
				$arr['rut']=$rut;
				$arr['f_nacimiento']=$f_nacimiento;
				$arr['fono_fijo']=$fono_fijo;
				$arr['fono_movil']=$fono_movil;
				$arr['pais']=$pais;
				$arr['ciudad']=$ciudad;
				$arr['comuna']=$comuna;
				$arr['direccion']=$direccion;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
		public function actualizaUsuario($datos){
		try{
			if($datos['pass1']!="" || $datos['pass2']!=""){
				$pass=md5($datos['pass1']);
				$conexion = Conectar::con();
				$sql="UPDATE usuarios set rut=?,genero=?,f_nacimiento=?,nombre=?,apepat=?,apemat=?,direccion=?,pais=?,ciudad=?,comuna=?,fono_fijo=?,fono_movil=?,email=?,clave=? WHERE id=?;";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("ssssssssssssssi",$datos['rut'],$datos['genero'],$datos['f_nac'],$datos['nombre'],$datos['apepat'],$datos['apemat'],$datos['direccion'],$datos['pais'],$datos['ciudad'],$datos['comuna'],$datos['fonofijo'],$datos['fonomovil'],$datos['email'],$pass,$datos['id']);
				
			}else{
				$pass=md5($datos['pass1']);
				$conexion = Conectar::con();
				$sql="UPDATE usuarios set rut=?,genero=?,f_nacimiento=?,nombre=?,apepat=?,apemat=?,direccion=?,pais=?,ciudad=?,comuna=?,fono_fijo=?,fono_movil=?,email=? WHERE id=?;";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("sssssssssssssi",$datos['rut'],$datos['genero'],$datos['f_nac'],$datos['nombre'],$datos['apepat'],$datos['apemat'],$datos['direccion'],$datos['pais'],$datos['ciudad'],$datos['comuna'],$datos['fonofijo'],$datos['fonomovil'],$datos['email'],$datos['id']);
			}
		
		
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
		
		}
		
	public function actualizaUsuario2($datos){
		try{
			if($datos['pass1']!="" || $datos['pass2']!=""){
				$pass=md5($datos['pass1']);
				$conexion = Conectar::con();
				$sql="UPDATE usuarios set rut=?,genero=?,id_perfil=?,f_nacimiento=?,nombre=?,apepat=?,apemat=?,direccion=?,pais=?,ciudad=?,comuna=?,fono_fijo=?,fono_movil=?,email=?,clave=? WHERE id=?;";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("ssissssssssssssi",$datos['rut'],$datos['genero'],$datos['perfil'],$datos['f_nac'],$datos['nombre'],$datos['apepat'],$datos['apemat'],$datos['direccion'],$datos['pais'],$datos['ciudad'],$datos['comuna'],$datos['fonofijo'],$datos['fonomovil'],$datos['email'],$pass,$datos['id']);
				
			}else{
				$pass=md5($datos['pass1']);
				$conexion = Conectar::con();
				$sql="UPDATE usuarios set rut=?,genero=?,id_perfil=?,f_nacimiento=?,nombre=?,apepat=?,apemat=?,direccion=?,pais=?,ciudad=?,comuna=?,fono_fijo=?,fono_movil=?,email=? WHERE id=?;";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("ssisssssssssssi",$datos['rut'],$datos['genero'],$datos['perfil'],$datos['f_nac'],$datos['nombre'],$datos['apepat'],$datos['apemat'],$datos['direccion'],$datos['pais'],$datos['ciudad'],$datos['comuna'],$datos['fonofijo'],$datos['fonomovil'],$datos['email'],$datos['id']);
			}
		
		
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				if($datos['pass1']!="" || $datos['pass2']!=""){
					$para = $datos['email'];
					$titulo = 'Registro I-Travel Administrador';
					$mensaje='<html>';
					$mensaje .='<head><title>I-travel</title></head>';
					$mensaje .='<body>';
					$mensaje .='<b>Estimado(a)'.$datos['nombre'].' '.$datos['apepat'].'</b><br>';
					$mensaje .='Le informamos que su cuenta de usuario ha sido modificada exitosamente.<br>';
					$mensaje .='Usuario: '.$datos['email'].'<br>';
					$mensaje .='Contraseña :  '.$datos['pass1'].'<br>';
					$mensaje .='Atentamente, <br>Administración<br></body>';
					
					$cabeceras  = 'MIME-Version: 1.0' . "\r\n";
					$cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
					$cabeceras .= 'From: I-Travel Web <itravel@noresponder.com>' . "\r\n";
					
					mail($para, $titulo, $mensaje, $cabeceras);
				}
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
		
	}	
		
	public function paginas(){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			$sql = "SELECT * FROM clientes"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}

	public function getUsuarios($desde,$nombre,$rut,$id_usuario){
		try{
			$conexion = Conectar::con();
			$buscar ="";
			
			if($nombre!=""){
				$buscar = "nombre LIKE '%".$nombre."%' AND";
			}
			
			if($rut!=""){
				$buscar = "rut LIKE '%".$rut."%' AND";
			}
			
			
			$sql = "SELECT id,estado,nombre,apepat,rut,fono_fijo FROM usuarios WHERE ".$buscar." id<>'' ORDER BY id ASC LIMIT 10 OFFSET ?;";

			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$desde);	
			$sentencia->execute();
			
			$sentencia->bind_result($id,$estado,$nombre,$apepat,$rut,$fono1);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['estado']=$estado;
				$arr[$i]['nombre']=$nombre." ".$apepat;
				$arr[$i]['rut']=$rut;
				$arr[$i]['fono1']=$fono1;
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
		public function validaCorreous ($email){
		try{
			if($email=="" || $email== null || $email == "null"){
				return "error";
			}else{
				$conexion = Conectar::con();
				$sql = "SELECT * FROM usuarios WHERE email=?;";
				
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("s",$email);		
				$sentencia->execute();
				
				$sentencia->store_result();
				return $sentencia->num_rows;
				
				$conexion->close();
				$sentencia->close();
				
				
			}		
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function crearUsuario($datos){
		try{
			$conexion = Conectar::con();
			$fec_crea = date('Y-m-d');
			$passcorreo=$datos['pass1'];
			$pass=md5($datos['pass1']);
			
			//id_perfil,estado,f_creacion,nombre,apepat,apemat,email,clave,genero,rut,f_nacimiento,fono_fijo,fono_movil,pais,ciudad,comuna,direccion

			$sql = "INSERT INTO usuarios(id_perfil,estado,f_creacion,nombre,apepat,apemat,email,clave,genero,rut,f_nacimiento,fono_fijo,fono_movil,pais,ciudad,comuna,direccion) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("iisssssssssssssss",$datos['perfil'],$datos['estado'],$fec_crea,$datos['nombre'],$datos['apepat'],$datos['apemat'],$datos['email'],$pass,$datos['genero'],$datos['rut'],$datos['f_nac'],$datos['fonofijo'],$datos['fonomovil'],$datos['pais'],$datos['ciudad'],$datos['comuna'],$datos['direccion']);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				
				$para = $datos['email'];
				$titulo = 'Registro I-Travel Administrador';
				$mensaje='<html>';
				$mensaje .='<head><title>I-travel</title></head>';
				$mensaje .='<body>';
				$mensaje .='<b>Estimado(a)'.$datos['nombre'].' '.$datos['apepat'].'</b><br>';
				$mensaje .='Le informamos que su cuenta de usuario ha sido creada exitosamente.<br>';
				$mensaje .='Usuario: '.$datos['email'].'<br>';
				$mensaje .='Contraseña :  '.$datos['pass1'].'<br>';
				$mensaje .='Atentamente, <br>Administración<br></body>';
				
				$cabeceras  = 'MIME-Version: 1.0' . "\r\n";
				$cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
				$cabeceras .= 'From: I-Travel Web <itravel@noresponder.com>' . "\r\n";
				
				mail($para, $titulo, $mensaje, $cabeceras);
				
				return $conexion->insert_id;// retorna el id creado
				//echo '<script language="javascript">alert("El usuario se ha creado correctament, se ha enviado un correo con su usuario y clave.");</script>'; 
			
			}
	
			$conexion->close();
            $sentencia->close();		
	
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	public function cambiaEstado($id){
		try{
			$conexion = Conectar::con();
			$sql="UPDATE usuarios SET estado = IF(estado = 1, 0, 1) WHERE id =?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();

			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
            $sentencia->close();
			
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	
	
	
	
}

class administracion extends Conectar{
	public function borrarCheque($id){
		try{
			$sql = "DELETE FROM cheques WHERE id=?";
			$conexion = Conectar::con();
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}

		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function addCheque($datos){
		try{
			$conexion = Conectar::con();
			$n_cuenta='';
			
			if($datos['cuenta']=='PESO'){
				$n_cuenta='159-22041-06';
			}else{
				$n_cuenta='5-159-22041-00';
			}
			
			$rutgirador='76.006.128-K';
			$nombre_girador='EMPRESA DE TURISMO CHILETOURS LTDA.';
			$banco='BANCO DE CHILE';
			$estado='emitido';
			$tipo_cheque='girado';
			$fecha_crea = date('Y-m-d');
			
			$sql = "INSERT INTO cheques(id_us_crea,fecha_crea,rut_girador,nombre_girador,banco,n_cuenta,n_cheque,monto,fecha_cobro,estado,tipo_cuenta,tipo_cheque,detalle,receptor) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("isssssssssssss",$datos['id_us_crea'],$fecha_crea,$rutgirador,$nombre_girador,$banco,$n_cuenta,$datos['n_cheque'],$datos['monto'],$datos['fecha_cobro'],$estado,$datos['cuenta'],$tipo_cheque,$datos['detalle'],$datos['receptor']);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else{
				return $conexion->insert_id;
			}
			
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }	
	}
	
	
	
	
	public function addChequeCobrarNew($datos){
		try{
			$conexion = Conectar::con();			
			$estado='pendiente';
			$tipo_cheque='cobrar';
			$fec_crea = date('Y-m-d');
			$sql = "INSERT INTO cheques(id_us_crea,fecha_crea,rut_girador,nombre_girador,banco,n_cuenta,n_cheque,monto,fecha_cobro,estado,pax,tipo_cuenta,tipo_cheque,receptor,detalle) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("issssssssssssss",$datos['id_us_crea'],$fec_crea,$datos['rut_girador'],$datos['nombre_girador'],$datos['banco'],$datos['n_cuenta'],$datos['n_cheque'],$datos['monto'],$datos['fecha_cobro'],$estado,$datos['pax'],$datos['tipo_moneda'],$tipo_cheque,$datos['receptor'],$datos['detalle']);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else{
				return $conexion->insert_id;
			}
			
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }	
	}
	
	
	
	public function EnviarSaludosFOR($cuenta,$correos){
		try{
			$conexion = Conectar::con();
			$saludoe='';
			$cuerpoe='';
			$imagene='';
			$actual_link_img = '';
			$autoint='';
			
			$sql = "SELECT max(autoint) FROM log_mail;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($maxint);
			$sentencia->store_result();
			
			if($sentencia->num_rows>0){
				while ($sentencia->fetch()) {
					$autoint=$maxint+1;
				}
			}else{
				$autoint=1;
			}
			
			
			$sql = "SELECT id,saludo,cuerpo,imagen,asunto FROM saludo WHERE id=1;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($id,$saludo,$cuerpo,$imagen,$asunto);
			$arr = array();
			
			 while ($sentencia->fetch()) {
				 $saludoe=$saludo;
				 $cuerpoe=$cuerpo;
				 $imagene=$imagen;
				 $asuntoe=$asunto;
			}
			
			if($imagene!=''){
				//$actual_link_img = '<img src="http://'.$_SERVER['HTTP_HOST'].'/imagenes/'.$imagene.'">';
				$img='http://'.$_SERVER['HTTP_HOST'].'/imagenes/'.$imagene;
				$actual_link_img ="background-image:url('".$img."')";
				
			}
			
			$img_blank='http://'.$_SERVER['HTTP_HOST'].'/imagenes/1px.jpg';
			
			
			for($i=0;$i<count($correos);$i++){
				
				$crr=explode(',', $_POST[$i]);
				$para = $crr[1];
				$titulo = $asuntoe;
				$mensaje='<html>';
				$mensaje .='<head><title>'.$cuenta.'</title></head>';
				$mensaje .='<body>';
				
				/*
				
				$mensaje .='<!--[if gte mso 9]>';
				$mensaje .='<v:background xmlns:v="urn:schemas-microsoft-com:vml" fill="t">';
				$mensaje .='<v:fill type="tile" src="http://i-traveladm.softkinds.com/imagenes/salu20160617032146.jpg" />';
				$mensaje .='</v:background>';
				$mensaje .='<![endif]-->';
				$mensaje .='<table width="100%" cellpadding="0" cellspacing="0" border="0">';
				$mensaje .='<tr>';
				$mensaje .='<td align="center" background="http://i-traveladm.softkinds.com/imagenes/salu20160617032146.jpg">';
				$mensaje .='El resto del código de tu mail va aquí';
				$mensaje .='</td>';
				$mensaje .='</tr>';
				$mensaje .='</table>';
				
				*/

				
				$mensaje .='Si no puede visualizar el mail correctamente, por favor haga click ';
				$param = 'http://'.$_SERVER['SERVER_NAME'].'/mail.php?titulo='.$asuntoe.'&cli='.$crr[0].'&saludo='.$saludoe.'&cuerpo='.$cuerpoe;
				$mensaje .='<a href="'.$param.'">aqu&iacute;</a><br>';
				
				
				$mensaje .=$saludoe.'<br>';
				$mensaje .=$cuerpoe.'<br>';
				$mensaje .='<table border="0" background="'.$actual_link_img.'" style="width:847px;height:1004px;'.$actual_link_img.'">';
				$mensaje .='<tr height="395"><td colspan="2"></td></tr>';
				$mensaje .='<tr height="40"><td width="160"></td><td><font style="font-size:120%;" color="#626264">'.$crr[0].'</font></td></tr>';
				$mensaje .='<tr><td colspan="2"></td></tr>';
				$mensaje .='</table>';
				$mensaje .='<img src="'.$img_blank.'">';
				
				//$mensaje .=$actual_link_img.'<br>';
				$mensaje .='Atentamente, <br>'.$cuenta.'<br></body>';
				
				$cabeceras  = 'MIME-Version: 1.0' . "\r\n";
				$cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

				$cabeceras .= 'From: '.$cuenta.' <webitravel@noresponder.com>' . "\r\n";
				
				
				if(mail($para, $titulo, $mensaje, $cabeceras)){
					$conexion = Conectar::con();
					$sql = "INSERT INTO log_mail(autoint,nombre,email,fecha) VALUES(?,?,?,CURDATE());";
					$sentencia = $conexion->prepare($sql);
					$sentencia->bind_param("iss",$autoint,$crr[0],$crr[1]);
					$sentencia->execute();
					
					if ($sentencia->errno) {
						return "fallo!!! " . $sentencia->error;
					}
				}

			}			
		
			header("Location: viajes_saludos.php");
			exit();
		
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
	
	public function GetSaludo(){
		try{
			$conexion = Conectar::con();
			
			$sql = "SELECT id,saludo,cuerpo,imagen,asunto FROM saludo WHERE id=1;"; 
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($id,$saludo,$cuerpo,$imagen,$asunto);
			$arr = array();
			
			 while ($sentencia->fetch()) {
				 $arr['id']=$id;
				 $arr['saludo']=$saludo;
				 $arr['cuerpo']=$cuerpo;
				 $arr['imagen']=$imagen;
				 $arr['asunto']=$asunto;
			}

			$conexion->close();
            $sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
		
	}
	
	public function UpdtSaludo($inicio,$cuerpo,$asunto,$img){
		try{
			$conexion = Conectar::con();
			if($img['size']>0){
				$destino='';
				
				$sql = "SELECT imagen FROM saludo WHERE id=1 ;";
				$sentencia = $conexion->prepare($sql);
				$sentencia->execute();
				$sentencia->bind_result($imga);
				
				while ($sentencia->fetch()) {
					if($imga!=''){
						unlink('../imagenes/'.$imga);
					}
				}

				$destino = imgNom('salu',$img);
				move_uploaded_file($img['tmp_name'], '../imagenes/'.$destino);	
				
				$sql="UPDATE saludo SET imagen=? WHERE id=1;";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("s",$destino);
				$sentencia->execute();	
				
			}
			
			
			$sql = "UPDATE saludo SET saludo=?,cuerpo=?,asunto=? WHERE id=1;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("sss",$inicio,$cuerpo,$asunto);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
			$conexion->close();
			$sentencia->close();
			
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
		
	}
	
	
	
	
	
	public function GetClientesCum($fecha,$todoscli,$fechaini,$fechater)
	{
		try{
			$conexion = Conectar::con();

			if($todoscli=='todos'){
				$sql = "SELECT id,nombre,apepat,email,f_nac FROM clientes WHERE (email<>'' OR email IS NOT NULL) order by nombre ASC;"; 
				
			}elseif($todoscli=='fecharangoini'){
				$sql = "SELECT a.id,a.nombre,a.apepat,a.email,a.f_nac FROM negocios as b LEFT JOIN clientes as a ON a.id=b.id_cliente WHERE (email<>'' OR email IS NOT NULL) AND  b.f_inicio>='".$fechaini."' AND  b.f_inicio<='".$fechater."' order by a.nombre ASC;";	
			}elseif($todoscli=='fecharangoter'){
				$sql = "SELECT a.id,a.nombre,a.apepat,a.email,a.f_nac FROM negocios as b LEFT JOIN clientes as a ON a.id=b.id_cliente WHERE (email<>'' OR email IS NOT NULL) AND  b.f_termino>='".$fechaini."' AND  b.f_termino<='".$fechater."' order by a.nombre ASC;";	
			}else{
				if($fecha==''){$fecha=date('Y-m-j');}
				
				if($todoscli=='fechaini'){
					$sql = "SELECT a.id,a.nombre,a.apepat,a.email,a.f_nac FROM negocios as b LEFT JOIN clientes as a ON a.id=b.id_cliente WHERE (email<>'' OR email IS NOT NULL) AND   b.f_inicio='".$fecha."' order by a.nombre ASC;";
				}else if($todoscli=='fechaterm'){
					$sql = "SELECT a.id,a.nombre,a.apepat,a.email,a.f_nac FROM negocios as b LEFT JOIN clientes as a ON a.id=b.id_cliente WHERE (email<>'' OR email IS NOT NULL) AND   b.f_termino='".$fecha."' order by a.nombre ASC;";	
				}else{
					$sql = "SELECT id,nombre,apepat,email,f_nac FROM clientes WHERE (email<>'' OR email IS NOT NULL) AND MONTH(f_nac)=MONTH('".$fecha."') AND DAY(f_nac)=DAY('".$fecha."')  order by nombre ASC;";	
					
				}
			}
		
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($id,$nombre,$apepat,$email,$f_nac);
			$arr = array();
			$i=0;
			
			 while ($sentencia->fetch()) {
				 $arr[$i]['id']=$id;
				 $arr[$i]['nombre']=$nombre;
				 $arr[$i]['apepat']=$apepat;
				 $arr[$i]['email']=$email;
				 $i++;
			}

			$conexion->close();
            $sentencia->close();
			
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	
	}
	
	
	
	
	
	
	
	
	
	
	
	
	public function verOrigenCheque($tabla,$id){
		try{
			if($tabla=='pagos_negocio_cli'){
				$conexion = Conectar::con();
				$sql = "SELECT id_negocio FROM pagos_negocio_cli WHERE id=? LIMIT 1;";		
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("i",$id);				
				$sentencia->execute();
				$sentencia->bind_result($id);
				
				while ($sentencia->fetch())
				{
					return 'viajes_det.php?id='.$id;
				}
				
				$conexion->close();
				$sentencia->close();
			}
			
			
			if($tabla=='pagos_serv'){
				$conexion = Conectar::con();
				$sql = "SELECT b.id,b.id_negocio FROM pagos_serv as a LEFT JOIN servicios_negocios as b ON a.id_servicio=b.id WHERE a.id=? LIMIT 1;";		
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("i",$id);				
				$sentencia->execute();
				$sentencia->bind_result($id,$id_negocio);
				
				while ($sentencia->fetch())
				{
					return 'viajes_pagos.php?id_v='.$id_negocio.'&id_serv='.$id;
				}
				
				$conexion->close();
				$sentencia->close();
			}
			
			if($tabla=='gastos'){
				$conexion = Conectar::con();
				$sql = "SELECT CONCAT(YEAR(f_ingreso),'-',LPAD(MONTH(f_ingreso), 2, '0')) as fecha FROM gastos WHERE id=? LIMIT 1;";		
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("i",$id);				
				$sentencia->execute();
				$sentencia->bind_result($fecha);
				
				while ($sentencia->fetch())
				{
					return 'administracion_gastos_det.php?fecha_gasto='.$fecha;
				}
				
				$conexion->close();
				$sentencia->close();
			}
			
			
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }		
	}
	
	
	public function getUtilidadesPaginas($fini,$fterm,$vendedor){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			$buscar ="";
			
			if($vendedor!=""){
				$buscar = $buscar."f.id=".$vendedor." AND ";
			}
			
			if($fini!='' && $fterm!=''){
				$buscar = $buscar."a.f_ingreso_neg BETWEEN DATE('".$fini."') AND DATE('".$fterm."') AND ";
			}
			
			if($fini!='' && $fterm==''){
				$buscar = $buscar."a.f_ingreso_neg>=DATE('".$fini."') AND ";
			}
			
			if($fini=='' && $fterm!=''){
				$buscar = $buscar."a.f_ingreso_neg<=DATE('".$fterm."') AND ";
			}

			//$sql = "SELECT a.f_inicio,a.f_termino,CONCAT(YEAR(a.f_ingreso_neg),'-',MONTH(a.f_ingreso_neg)) as mesano,a.id,f.id,f.nombre,f.apepat,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_ingreso_neg,if(a.tipo_cambio='DOLAR',a.precio*a.valor_tipo_cambio,a.precio) as precio_viaje,e.valor_servicios,c.pago_servicios,d.pago_cliente FROM negocios as a LEFT JOIN usuarios as f ON a.id_us_crea=f.id LEFT JOIN clientes as b ON a.id_cliente=b.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY bb.id_negocio) as c ON c.id_negocio = a.id LEFT JOIN (SELECT aa.id_negocio,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_cliente FROM pagos_negocio_cli as aa LEFT JOIN negocios as bb ON aa.id_negocio=bb.id GROUP BY aa.id_negocio) as d ON d.id_negocio = a.id LEFT JOIN (SELECT id_negocio,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id_negocio) as e ON e.id_negocio = a.id WHERE ".$buscar." a.id IS NOT NULL GROUP BY a.id ORDER BY a.id DESC;";		
			$sql = "SELECT a.f_inicio,a.f_termino,CONCAT(YEAR(a.f_ingreso_neg),'-',MONTH(a.f_ingreso_neg)) as mesano,a.id,f.id,f.nombre,f.apepat,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_ingreso_neg,if(a.tipo_cambio='DOLAR',a.precio*a.valor_tipo_cambio,a.precio) as precio_viaje,e.valor_servicios,c.pago_servicios,d.pago_cliente,g.pago_cliente_contrans,h.cargo_transbank FROM negocios as a LEFT JOIN usuarios as f ON a.id_us_crea=f.id LEFT JOIN clientes as b ON a.id_cliente=b.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY bb.id_negocio) as c ON c.id_negocio = a.id LEFT JOIN (SELECT aa.id_negocio,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_cliente FROM pagos_negocio_cli as aa LEFT JOIN negocios as bb ON aa.id_negocio=bb.id GROUP BY aa.id_negocio) as d ON d.id_negocio = a.id LEFT JOIN (SELECT id_negocio,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id_negocio) as e ON e.id_negocio = a.id LEFT JOIN (SELECT aa.id_negocio,SUM(if(aa.n_cuotas='' OR  aa.n_cuotas IS NOT NULL, if(aa.tipo_moneda='DOLAR',(aa.total_cuota*aa.n_cuotas)*bb.valor_tipo_cambio,aa.total_cuota*aa.n_cuotas),if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto))) as pago_cliente_contrans FROM pagos_negocio_cli as aa LEFT JOIN negocios as bb ON aa.id_negocio=bb.id GROUP BY aa.id_negocio) as g ON g.id_negocio = a.id LEFT JOIN (SELECT aa.id_negocio,SUM(if(aa.n_cuotas='' OR  aa.n_cuotas IS NOT NULL,if(aa.tipo_moneda='DOLAR',aa.cargo_transbank*bb.valor_tipo_cambio,aa.cargo_transbank),'')) as cargo_transbank FROM pagos_negocio_cli as aa LEFT JOIN negocios as bb ON aa.id_negocio=bb.id GROUP BY aa.id_negocio)  as h ON h.id_negocio = a.id WHERE ".$buscar." a.id IS NOT NULL GROUP BY a.id ORDER BY a.id DESC;";
			//echo $sql;
			
			$sentencia = $conexion->prepare($sql);	
			$sentencia->execute();
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
	public function getUtilidades($desde,$fini,$fterm,$vendedor){
		try{
			$conexion = Conectar::con();
			$buscar ="";
			
			if($vendedor!=""){
				$buscar = $buscar."f.id=".$vendedor." AND ";
			}
			
			if($fini!='' && $fterm!=''){
				$buscar = $buscar."a.f_ingreso_neg BETWEEN DATE('".$fini."') AND DATE('".$fterm."') AND ";
			}
			
			if($fini!='' && $fterm==''){
				$buscar = $buscar."a.f_ingreso_neg>=DATE('".$fini."') AND ";
			}
			
			if($fini=='' && $fterm!=''){
				$buscar = $buscar."a.f_ingreso_neg<=DATE('".$fterm."') AND ";
			}
			
			//$sql = "SELECT a.f_inicio,a.f_termino,CONCAT(YEAR(a.f_ingreso_neg),'-',MONTH(a.f_ingreso_neg)) as mesano,a.id,f.id,f.nombre,f.apepat,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_ingreso_neg,if(a.tipo_cambio='DOLAR',a.precio*a.valor_tipo_cambio,a.precio) as precio_viaje,e.valor_servicios,c.pago_servicios,d.pago_cliente FROM negocios as a LEFT JOIN usuarios as f ON a.id_us_crea=f.id LEFT JOIN clientes as b ON a.id_cliente=b.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY bb.id_negocio) as c ON c.id_negocio = a.id LEFT JOIN (SELECT aa.id_negocio,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_cliente FROM pagos_negocio_cli as aa LEFT JOIN negocios as bb ON aa.id_negocio=bb.id GROUP BY aa.id_negocio) as d ON d.id_negocio = a.id LEFT JOIN (SELECT id_negocio,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id_negocio) as e ON e.id_negocio = a.id WHERE ".$buscar." a.id IS NOT NULL GROUP BY a.id ORDER BY a.id DESC LIMIT 10 OFFSET ?;";		
			
			$sql = "SELECT a.f_inicio,a.f_termino,CONCAT(YEAR(a.f_ingreso_neg),'-',MONTH(a.f_ingreso_neg)) as mesano,a.id,f.id,f.nombre,f.apepat,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_ingreso_neg,if(a.tipo_cambio='DOLAR',a.precio*a.valor_tipo_cambio,a.precio) as precio_viaje,e.valor_servicios,c.pago_servicios,d.pago_cliente,g.pago_cliente_contrans,h.cargo_transbank FROM negocios as a LEFT JOIN usuarios as f ON a.id_us_crea=f.id LEFT JOIN clientes as b ON a.id_cliente=b.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY bb.id_negocio) as c ON c.id_negocio = a.id LEFT JOIN (SELECT aa.id_negocio,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_cliente FROM pagos_negocio_cli as aa LEFT JOIN negocios as bb ON aa.id_negocio=bb.id GROUP BY aa.id_negocio) as d ON d.id_negocio = a.id LEFT JOIN (SELECT id_negocio,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id_negocio) as e ON e.id_negocio = a.id LEFT JOIN (SELECT aa.id_negocio,SUM(if(aa.n_cuotas='' OR  aa.n_cuotas IS NOT NULL, if(aa.tipo_moneda='DOLAR',(aa.total_cuota*aa.n_cuotas)*bb.valor_tipo_cambio,aa.total_cuota*aa.n_cuotas),if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto))) as pago_cliente_contrans FROM pagos_negocio_cli as aa LEFT JOIN negocios as bb ON aa.id_negocio=bb.id GROUP BY aa.id_negocio) as g ON g.id_negocio = a.id LEFT JOIN (SELECT aa.id_negocio,SUM(if(aa.n_cuotas='' OR  aa.n_cuotas IS NOT NULL,if(aa.tipo_moneda='DOLAR',aa.cargo_transbank*bb.valor_tipo_cambio,aa.cargo_transbank),'')) as cargo_transbank FROM pagos_negocio_cli as aa LEFT JOIN negocios as bb ON aa.id_negocio=bb.id GROUP BY aa.id_negocio)  as h ON h.id_negocio = a.id WHERE ".$buscar." a.id IS NOT NULL GROUP BY a.id ORDER BY a.id DESC LIMIT 10 OFFSET ?;";
			
			$sentencia = $conexion->prepare($sql);	
			$sentencia->bind_param("i",$desde);	
			$sentencia->execute();
			$sentencia->bind_result($f_inicio,$f_termino,$mesano,$id,$id_vendedor,$nomusu,$apeusu,$nombre,$apepat,$rut,$destino,$tipo_cuenta,$tipo_cliente,$f_crea,$precio_viaje,$valor_servicios,$pago_servicios,$pago_cliente,$pago_cliente_contrans,$cargo_transbank);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['id_vendedor']=$id_vendedor;
				$arr[$i]['f_inicio']=$f_inicio;
				$arr[$i]['f_termino']=$f_termino;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['apepat']=$apepat;
				$arr[$i]['rut']=$rut;
				$arr[$i]['destino']=$destino;
				$arr[$i]['tipo_cuenta']=$tipo_cuenta;
				$arr[$i]['tipo_cliente']=$tipo_cliente;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['nomusu']=$nomusu;
				$arr[$i]['apeusu']=$apeusu;
				$arr[$i]['precio_viaje']=$precio_viaje;
				$arr[$i]['valor_servicios']=$valor_servicios;
				$arr[$i]['pago_servicios']=$pago_servicios;
				$arr[$i]['pago_cliente']=$pago_cliente;
				$arr[$i]['mesano']=$mesano;
				$arr[$i]['pago_cliente_contrans']=$pago_cliente_contrans;
				$arr[$i]['cargo_transbank']=$cargo_transbank;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function getUtilidadesGroup($fini,$fterm,$vendedor){
		try{
			$conexion = Conectar::con();
			$buscar ="";
			
			if($vendedor!=""){
				$buscar = $buscar."f.id=".$vendedor." AND ";//OK
			}
			
			if($fini!='' && $fterm!=''){
				$buscar = $buscar."a.f_ingreso_neg BETWEEN '".$fini."' AND '".$fterm."' AND ";//OK
			}
			
			if($fini!='' && $fterm==''){
					
				$buscar = $buscar."a.f_ingreso_neg='".$fini."' AND ";
			}
			
			if($fini=='' && $fterm!=''){
				$buscar = $buscar."a.f_ingreso_neg='".$fterm."' AND ";
			}
			
			
			$sql = "SELECT CONCAT(YEAR(a.f_ingreso_neg),'-',MONTH(a.f_ingreso_neg)) as fec,SUM(if(a.tipo_cambio='DOLAR',a.precio*a.valor_tipo_cambio,a.precio) - e.valor_servicios) AS util FROM negocios as a LEFT JOIN usuarios as f ON a.id_us_crea=f.id LEFT JOIN clientes as b ON a.id_cliente=b.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY bb.id_negocio) as c ON c.id_negocio = a.id LEFT JOIN (SELECT aa.id_negocio,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_cliente FROM pagos_negocio_cli as aa LEFT JOIN negocios as bb ON aa.id_negocio=bb.id GROUP BY aa.id_negocio) as d ON d.id_negocio = a.id LEFT JOIN (SELECT id_negocio,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id_negocio) as e ON e.id_negocio = a.id WHERE ".$buscar." a.id IS NOT NULL GROUP BY YEAR(a.f_ingreso_neg),MONTH(a.f_ingreso_neg) ORDER BY a.f_ingreso_neg DESC LIMIT 12;";

			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($fec,$util);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['fec']=$fec;
				$arr[$i]['util']=$util;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function moverCheque($id){
		try{
			$conexion = Conectar::con();
			//$sql="UPDATE cheques SET estado=IF(estado='pendiente','cobrado','pendiente') WHERE id =?;";
			
			
			$sql="UPDATE cheques SET estado=if(tipo_cheque='girado',IF(estado='emitido','cobrado','emitido'),IF(estado='pendiente','cobrado','pendiente')) WHERE id=?;";
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();

			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
            $sentencia->close();
			
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}
	
	public function udtCheque($datos){
		try{
			$conexion = Conectar::con();
			//$sql="UPDATE cheques SET estado=IF(estado='pendiente','cobrado','pendiente') WHERE id =?;";
			$sql="UPDATE cheques SET rut_girador=?,nombre_girador=?,banco=?,n_cuenta=?,n_cheque=?,fecha_cobro=?,pax=? WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("sssssssi",$datos['rut_girador'],$datos['nombre_girador'],$datos['banco'],$datos['n_cuenta'],$datos['n_cheque'],$datos['fecha_cobro'],$datos['pax'],$datos['id']);
			$sentencia->execute();

			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
			
			$conexion->close();
            $sentencia->close();
			
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}

	
	/////////////////////////////////////////
	public function listaViajesFILCount($tipo,$cuenta,$fini,$ffin,$nombre,$id_us){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			$buscar ="";

			if($cuenta=='CYM'){
				$buscar=$buscar." AND a.tipo_cuenta='CYM' ";
			}else if($cuenta=='I-travel'){
				$buscar=$buscar." AND a.tipo_cuenta='I-travel' ";
			}
			
			if($nombre!=''){
				$buscar=$buscar." AND a.nombre_pasa_pri LIKE '%".$nombre."%'";
			}
			
			if($fini!='' && $ffin!=''){
				$buscar=$buscar." AND DATE(a.f_inicio)>DATE('".$fini."') AND DATE(a.f_termino)<DATE('".$ffin."') ";
			}
				
			if($fini=='' && $ffin!=''){
				$buscar=$buscar." AND DATE(a.f_termino)<DATE('".$ffin."') ";
			}
				
			if($fini!='' && $ffin==''){
				$buscar=$buscar." AND DATE(a.f_inicio)>DATE('".$fini."') ";
			}
			
			if($id_us!=''){
				$buscar=$buscar." AND a.id_us_crea=".$id_us." ";
			}
			
			
			$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_inicio=curdate() ".$buscar." ORDER BY a.f_inicio DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$hoy=$sentencia->num_rows;
			
			$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_termino<>'0000-00-00' AND DATE(a.f_inicio)<CURDATE() AND DATE(a.f_termino)>CURDATE() ".$buscar." ORDER BY a.f_inicio DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$viajando=$sentencia->num_rows;
			
			$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_termino<>'0000-00-00' AND DATE(a.f_inicio)>CURDATE()".$buscar." ORDER BY a.f_inicio DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$proximos=$sentencia->num_rows;
			
			$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio='0000-00-00' OR a.f_termino='0000-00-00' ".$buscar." ORDER BY a.f_inicio DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$sinfecha=$sentencia->num_rows;
			
			$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_termino<>'0000-00-00' AND DATE(a.f_termino)<CURDATE()".$buscar." ORDER BY a.f_inicio DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$viajaron=$sentencia->num_rows;
			
			$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE  a.id IS NOT NULL ".$buscar." ORDER BY a.f_inicio DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$todos=$sentencia->num_rows;
			
			

			return array('hoy'=>$hoy,'viajando'=>$viajando,'proximos'=>$proximos,'sinfecha'=>$sinfecha,'viajaron'=>$viajaron,'todos'=>$todos);
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
	public function contarInicio(){
		try{
			$conexion = Conectar::con();

			$sql = "SELECT * FROM clientes as a WHERE a.f_nac<>'0000-00-00' AND a.f_nac=curdate();";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$cumphoy=$sentencia->num_rows;
			
			$sql = "SELECT * FROM clientes as a WHERE a.f_nac<>'0000-00-00' AND a.f_nac >= CURDATE() AND a.f_nac<=DATE_ADD(CURDATE(), INTERVAL 7 DAY);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$cumpsemana=$sentencia->num_rows;
			
			$sql = "SELECT * FROM negocios as a WHERE a.f_inicio<>'0000-00-00' AND a.f_inicio=curdate();";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$vhoy=$sentencia->num_rows;
			
			$sql = "SELECT * FROM negocios as a WHERE a.f_inicio<>'0000-00-00' AND a.f_inicio >= CURDATE() AND a.f_inicio<=DATE_ADD(CURDATE(), INTERVAL 7 DAY);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$vsemana=$sentencia->num_rows;

			return array('cumphoy'=>$cumphoy,'cumpsemana'=>$cumpsemana,'vhoy'=>$vhoy,'vsemana'=>$vsemana);
			
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
	
	
	public function listaViajesFILPag($tipo,$cuenta,$fini,$ffin,$nombre,$id_us){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			$buscar ="";
					
				
			if($cuenta=='CYM'){
				$buscar=$buscar." AND a.tipo_cuenta='CYM' ";
			}else if($cuenta=='I-travel'){
				$buscar=$buscar." AND a.tipo_cuenta='I-travel' ";
			}
			
			if($nombre!=''){
				$buscar=$buscar." AND a.nombre_pasa_pri LIKE '%".$nombre."%'";
			}
			
			if($fini!='' && $ffin!=''){
				$buscar=$buscar." AND DATE(a.f_inicio)>DATE('".$fini."') AND DATE(a.f_termino)<DATE('".$ffin."') ";
			}
				
			if($fini=='' && $ffin!=''){
				$buscar=$buscar." AND DATE(a.f_termino)<DATE('".$ffin."') ";
			}
				
			if($fini!='' && $ffin==''){
				$buscar=$buscar." AND DATE(a.f_inicio)>DATE('".$fini."') ";
			}
			
			if($id_us!=''){
				$buscar=$buscar." AND a.id_us_crea=".$id_us." ";
			}
			
			
			if($tipo=='hoy'){
				$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_inicio=curdate() ".$buscar." ORDER BY a.f_inicio DESC;";
			}
			
			if($tipo=='viajando'){
				$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_termino<>'0000-00-00' AND DATE(a.f_inicio)<CURDATE() AND DATE(a.f_termino)>CURDATE() ".$buscar." ORDER BY a.f_inicio DESC;";
			}
			
			if($tipo=='proximos'){
				$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_termino<>'0000-00-00' AND DATE(a.f_inicio)>CURDATE()".$buscar." ORDER BY a.f_inicio DESC;";
			}
			
			if($tipo=='sinfecha'){
				$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio='0000-00-00' OR a.f_termino='0000-00-00' ".$buscar." ORDER BY a.f_inicio DESC;";
			}
			
			if($tipo=='viajaron'){
				$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_termino<>'0000-00-00' AND DATE(a.f_termino)<CURDATE()".$buscar." ORDER BY a.f_inicio DESC;";
			}
			
			if($tipo==''){
				$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.id IS NOT NULL ".$buscar." ORDER BY a.f_inicio DESC;";
			}
			

			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}

	public function listaViajesFIL($desde,$tipo,$cuenta,$fini,$ffin,$nombre,$id_us){
		try{
			$conexion = Conectar::con();
			$buscar ="";
				
			if($cuenta=='CYM'){
				$buscar=$buscar." AND a.tipo_cuenta='CYM' ";
			}else if($cuenta=='I-travel'){
				$buscar=$buscar." AND a.tipo_cuenta='I-travel' ";
			}
			
			if($nombre!=''){
				$buscar=$buscar." AND a.nombre_pasa_pri LIKE '%".$nombre."%'";
			}
			
			if($fini!='' && $ffin!=''){
				$buscar=$buscar." AND DATE(a.f_inicio)>DATE('".$fini."') AND DATE(a.f_termino)<DATE('".$ffin."') ";
			}
				
			if($fini=='' && $ffin!=''){
				$buscar=$buscar." AND DATE(a.f_termino)<DATE('".$ffin."') ";
			}
				
			if($fini!='' && $ffin==''){
				$buscar=$buscar." AND DATE(a.f_inicio)>DATE('".$fini."') ";
			}
			
			if($id_us!=''){
				$buscar=$buscar." AND a.id_us_crea=".$id_us." ";
			}
			
			
			if($tipo=='hoy'){
				$sql = "SELECT a.nombre_pasa_pri,a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_inicio=curdate() ".$buscar." ORDER BY a.f_inicio DESC LIMIT 10 OFFSET ?;";
			}
			
			if($tipo=='viajando'){
				$sql = "SELECT a.nombre_pasa_pri,a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_termino<>'0000-00-00' AND DATE(a.f_inicio)<CURDATE() AND DATE(a.f_termino)>CURDATE() ".$buscar." ORDER BY a.f_inicio DESC LIMIT 10 OFFSET ?;";
			}
			
			if($tipo=='proximos'){
				$sql = "SELECT a.nombre_pasa_pri,a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_termino<>'0000-00-00' AND DATE(a.f_inicio)>CURDATE()".$buscar." ORDER BY a.f_inicio ASC LIMIT 10 OFFSET ?;";
			}
			
			if($tipo=='sinfecha'){
				$sql = "SELECT a.nombre_pasa_pri,a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio='0000-00-00' OR a.f_termino='0000-00-00' ".$buscar." ORDER BY a.f_inicio DESC LIMIT 10 OFFSET ?;";
			}
			
			if($tipo=='viajaron'){
				$sql = "SELECT a.nombre_pasa_pri,a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_termino<>'0000-00-00' AND DATE(a.f_termino)<CURDATE()".$buscar." ORDER BY a.f_inicio DESC LIMIT 10 OFFSET ?;";
			}
			
			if($tipo==''){
				$sql = "SELECT a.nombre_pasa_pri,a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.id IS NOT NULL ".$buscar." ORDER BY a.f_inicio DESC LIMIT 10 OFFSET ?;";
			}
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$desde);	
			$sentencia->execute();
			
			$sentencia->bind_result($nombre_pasa_pri,$id,$nombre,$apepat,$rut,$destino,$tipo_cuenta,$tipo_cliente,$f_crea,$n_pasajero,$f_inicio,$f_termino);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['apepat']=$apepat;
				$arr[$i]['rut']=$rut;
				$arr[$i]['destino']=$destino;
				$arr[$i]['tipo_cuenta']=strtoupper($tipo_cuenta);
				$arr[$i]['tipo_cliente']=$tipo_cliente;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['n_pasajero']=$n_pasajero;
				$arr[$i]['f_inicio']=$f_inicio;
				$arr[$i]['f_termino']=$f_termino;
				$arr[$i]['nombre_pasa_pri']=$nombre_pasa_pri;
				$i++;
			}
			return $arr;
			
			$conexion->close();
				$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
	
	public function listaViajes($tab,$cuenta,$fini,$ffin){
		try{
			$conexion = Conectar::con();
			//$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE ".$buscar." a.id is not NULL ORDER BY a.id ASC LIMIT 10 OFFSET ?;";
			
			$cuentawhere='';	
			if($cuenta=='CYM'){
				$cuentawhere=" AND a.tipo_cuenta='CYM' ";
			}else if($cuenta=='I-TRAVEL'){
				$cuentawhere=" AND a.tipo_cuenta='I-travel' ";
			}else if($cuenta=='ambos'){
				$cuentawhere='';
			}
			
			if($tab=='hoy'){
				$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_inicio=curdate()".$cuentawhere."ORDER BY a.id DESC;";
			}
			
			if($tab=='viajando'){
				$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_termino<>'0000-00-00' AND DATE(a.f_inicio)<CURDATE() AND DATE(a.f_termino)>CURDATE()".$cuentawhere."ORDER BY a.id DESC;";
			}
			
			if($tab=='proximos'){
				$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_termino<>'0000-00-00' AND DATE(a.f_inicio)>CURDATE()".$cuentawhere."ORDER BY a.id DESC;";
			}
			
			if($tab=='sinfecha'){
				$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio='0000-00-00' OR a.f_termino='0000-00-00'".$cuentawhere."ORDER BY a.id DESC;";
			}
			
			if($tab=='todos'){
				if($fini!='' && $ffin!=''){
				$cuentawhere=$cuentawhere." AND DATE(a.f_inicio)>DATE('".$fini."') AND DATE(a.f_termino)<DATE('".$ffin."') ";
				}
				
				if($fini=='' && $ffin!=''){
					$cuentawhere=$cuentawhere." AND DATE(a.f_termino)<DATE('".$ffin."') ";
				}
				
				if($fini!='' && $ffin==''){
					$cuentawhere=$cuentawhere." AND DATE(a.f_inicio)>DATE('".$fini."') ";
				}
				
				$sql = "SELECT a.id,b.nombre,b.apepat,b.rut,a.destino,a.tipo_cuenta,a.tipo_cliente,a.f_crea,a.n_pasajero,a.f_inicio,a.f_termino FROM negocios as a LEFT JOIN clientes as b ON a.id_cliente=b.id WHERE a.f_inicio<>'0000-00-00' AND a.f_termino<>'0000-00-00' ".$cuentawhere." ORDER BY a.id DESC;";
			}
			
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($id,$nombre,$apepat,$rut,$destino,$tipo_cuenta,$tipo_cliente,$f_crea,$n_pasajero,$f_inicio,$f_termino);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch())
			 {
				$arr[$i]['id']=$id;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['apepat']=$apepat;
				$arr[$i]['rut']=$rut;
				$arr[$i]['destino']=$destino;
				$arr[$i]['tipo_cuenta']=strtoupper($tipo_cuenta);
				$arr[$i]['tipo_cliente']=$tipo_cliente;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['n_pasajero']=$n_pasajero;
				$arr[$i]['f_inicio']=$f_inicio;
				$arr[$i]['f_termino']=$f_termino;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function getChequesPaginas($tipo_cheque,$estado,$tipo_cuenta,$fecha,$orden,$id_cheque,$n_cheque){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			$query='';
			if($fecha!=''){
				$query="AND a.fecha_cobro='".$fecha."' ";
			}
			if($id_cheque!=''){
				$query="AND a.id='".$id_cheque."' ";
			}
			
			if($n_cheque!=''){
				$query="AND a.n_cheque='".$n_cheque."' ";
			}
			
			$sql="SELECT a.id,CONCAT(SUBSTRING(b.nombre,1,1),SUBSTRING(b.apepat,1,1)) as usuario,a.fecha_crea,a.id_tabla_aso,a.nom_tabla,a.rut_girador,a.nombre_girador,a.banco,a.n_cuenta,a.n_cheque,a.monto,a.fecha_cobro,a.estado,a.pax,a.tipo_cuenta,a.tipo_cheque FROM cheques as a LEFT JOIN usuarios as b ON a.id_us_crea=b.id WHERE a.estado='".$estado."' AND a.tipo_cuenta='".$tipo_cuenta."' AND a.tipo_cheque='".$tipo_cheque."' ".$query." ORDER BY a.fecha_cobro ".$orden.";";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function getCheques($tipo_cheque,$estado,$tipo_cuenta,$desde,$fecha,$orden,$id_cheque,$n_cheque){
		try{
			$conexion = Conectar::con();
			$query='';
			if($fecha!=''){
				$query="AND a.fecha_cobro='".$fecha."' ";
			}
			
			if($id_cheque!=''){
				$query="AND a.id='".$id_cheque."' ";
			}
			
			if($n_cheque!=''){
				$query="AND a.n_cheque='".$n_cheque."' ";
			}
			
			$sql="SELECT a.id,CONCAT(SUBSTRING(b.nombre,1,1),SUBSTRING(b.apepat,1,1)) as usuario,a.fecha_crea,a.id_tabla_aso,a.nom_tabla,a.rut_girador,a.nombre_girador,a.banco,a.n_cuenta,a.n_cheque,a.monto,a.fecha_cobro,a.estado,a.pax,a.tipo_cuenta,a.tipo_cheque,a.detalle,a.receptor FROM cheques as a LEFT JOIN usuarios as b ON a.id_us_crea=b.id WHERE a.estado='".$estado."' AND a.tipo_cuenta='".$tipo_cuenta."' AND a.tipo_cheque='".$tipo_cheque."' ".$query." ORDER BY a.fecha_cobro ".$orden." LIMIT 10 OFFSET ?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$desde);	
			$sentencia->execute();
			$sentencia->bind_result($id,$usuario,$fecha_crea,$id_tabla_aso,$nom_tabla,$rut_girador,$nombre_girador,$banco,$n_cuenta,$n_cheque,$monto,$fecha_cobro,$estado,$pax,$tipo_cuenta,$tipo_cheque,$detalle,$receptor);
			$arr = array();
			$i=0; 
			
			 while ($sentencia->fetch()){
				$arr[$i]['id']=$id;
				$arr[$i]['usuario']=$usuario;
				$arr[$i]['fecha_crea']=$fecha_crea;
				$arr[$i]['id_tabla_aso']=$id_tabla_aso;
				$arr[$i]['nom_tabla']=$nom_tabla;
				$arr[$i]['rut_girador']=$rut_girador;
				$arr[$i]['nombre_girador']=$nombre_girador;
				$arr[$i]['banco']=$banco;
				$arr[$i]['n_cuenta']=$n_cuenta;
				$arr[$i]['n_cheque']=$n_cheque;
				$arr[$i]['monto']=$monto;
				$arr[$i]['fecha_cobro']=$fecha_cobro;
				$arr[$i]['estado']=$estado;
				$arr[$i]['pax']=$pax;
				$arr[$i]['tipo_cuenta']=$tipo_cuenta;
				$arr[$i]['tipo_cheque']=$tipo_cheque;
				$arr[$i]['id_receptor']='';
				$arr[$i]['nombre_receptor']='';
				$arr[$i]['link_receptor']='';
				$arr[$i]['detalle']=$detalle;
				$arr[$i]['receptor']=$receptor;
				
				if($nom_tabla=='pagos_serv'){
					$conexion2 = Conectar::con();
					$sql2="SELECT a.id,a.nombre FROM proveedores as a LEFT JOIN servicios_negocios as b ON a.id=b.id_proveedor LEFT JOIN pagos_serv as c ON b.id=c.id_servicio WHERE c.id=".$id_tabla_aso." LIMIT 1;";
					$sentencia2 = $conexion2->prepare($sql2);
					$sentencia2->execute();
					$sentencia2->bind_result($id_r,$nombre_r);
					while ($sentencia2->fetch()){
						$arr[$i]['id_receptor']=$id_r;
						$arr[$i]['nombre_receptor']=$nombre_r;	
						$arr[$i]['link_receptor']='proveedores_ficha.php?id_prov='.$id_r;
					}
					$conexion2->close();
					$sentencia2->close();

				}else if($nom_tabla=='gastos'){
					$conexion2 = Conectar::con();
					$sql2="SELECT id,razon,CONCAT(YEAR(f_ingreso),'-',MONTH(f_ingreso)) FROM gastos WHERE id=".$id_tabla_aso." LIMIT 1;";
					$sentencia2 = $conexion2->prepare($sql2);
					$sentencia2->execute();
					$sentencia2->bind_result($id_r,$nombre_r,$fecha);
					while ($sentencia2->fetch()){
						$arr[$i]['id_receptor']=$id_r;
						$arr[$i]['nombre_receptor']=$nombre_r;
						$arr[$i]['link_receptor']='administracion_gastos_det.php?fecha_gasto='.$fecha;						
					}
					$conexion2->close();
					$sentencia2->close();
				}
				
				
				$i++;
			}
			
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
	
	public function getMontoCheq(){
		try{
			$valores = array();
			$conexion = Conectar::con();
			$sql="SELECT sum(monto) as suma1 FROM cheques WHERE tipo_cuenta='DOLAR' AND estado='pendiente' AND tipo_cheque='cobrar';";
			$sql2="SELECT sum(monto) as suma2 FROM cheques WHERE tipo_cuenta='PESO' AND estado='pendiente' AND tipo_cheque='cobrar';";
			$sql5="SELECT sum(monto) as suma2 FROM cheques WHERE tipo_cuenta='DOLAR' AND estado='cobrado' AND tipo_cheque='cobrar';";
			$sql6="SELECT sum(monto) as suma2 FROM cheques WHERE tipo_cuenta='PESO' AND estado='cobrado' AND tipo_cheque='cobrar';";
				
			$sql3="SELECT sum(monto) as suma2 FROM cheques WHERE tipo_cuenta='DOLAR' AND estado='emitido' AND tipo_cheque='girado';";
			$sql4="SELECT sum(monto) as suma2 FROM cheques WHERE tipo_cuenta='PESO' AND estado='emitido' AND tipo_cheque='girado';";
			$sql7="SELECT sum(monto) as suma2 FROM cheques WHERE tipo_cuenta='DOLAR' AND estado='cobrado' AND tipo_cheque='girado';";
			$sql8="SELECT sum(monto) as suma2 FROM cheques WHERE tipo_cuenta='PESO' AND estado='cobrado' AND tipo_cheque='girado';";
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($suma);
			while ($sentencia->fetch())
			 {
				$valores['pendientedolar']=$suma; 
			 }
			 
			$sentencia = $conexion->prepare($sql2);
			$sentencia->execute();
			$sentencia->bind_result($suma);
			while ($sentencia->fetch())
			 {
				$valores['pendientepeso']=$suma; 
			 }

			 
			$sentencia = $conexion->prepare($sql3);
			$sentencia->execute();
			$sentencia->bind_result($suma);
			while ($sentencia->fetch())
			 {
				$valores['giradodolar']=$suma; 
			 }

			 
			 $sentencia = $conexion->prepare($sql4);
			$sentencia->execute();
			$sentencia->bind_result($suma);
			while ($sentencia->fetch())
			 {
				$valores['giradopeso']=$suma; 
			 }

			
			
			$sentencia = $conexion->prepare($sql5);
			$sentencia->execute();
			$sentencia->bind_result($suma);
			while ($sentencia->fetch())
			 {
				$valores['cobradodolar']=$suma; 
			 }
			 
			 
			$sentencia = $conexion->prepare($sql6);
			$sentencia->execute();
			$sentencia->bind_result($suma);
			while ($sentencia->fetch())
			 {
				$valores['cobradopeso']=$suma; 
			 }
			 
			 
			 
			 $sentencia = $conexion->prepare($sql7);
			$sentencia->execute();
			$sentencia->bind_result($suma);
			while ($sentencia->fetch())
			 {
				$valores['girado_cobrado_dolar']=$suma; 
			 }
			 
			 
			$sentencia = $conexion->prepare($sql8);
			$sentencia->execute();
			$sentencia->bind_result($suma);
			while ($sentencia->fetch())
			 {
				$valores['girado_cobrado_peso']=$suma; 
			 }
			 
			 
			 
			 
			 
			 
			
			
			return $valores;
			
			$conexion->close();
			$sentencia->close();
			
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	
	public function getServiciosPagos($prov){
		try{
			$conexion = Conectar::con();			
			//$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,IF(a.tipo_cambio='DOLAR',a.valor*a.valor_tipo_cambio,a.valor) as val_neg_pesos,d.t_pago_pesos FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT aa.id as id,bb.id as id_servicio,SUM(IF(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as t_pago_pesos FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY bb.id)as d ON d.id_servicio = a.id ORDER BY a.id;";
			
			
			if($prov!=''){
				//$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,IF(a.tipo_cambio='DOLAR',a.valor*a.valor_tipo_cambio,a.valor) as val_neg_pesos,d.t_pago_pesos,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT aa.id as id,bb.id as id_servicio,SUM(IF(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as t_pago_pesos FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY bb.id)as d ON d.id_servicio = a.id LEFT JOIN (SELECT id_negocio,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id_negocio) as e ON e.id_negocio = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_negocio = a.id WHERE c.nombre LIKE '%".$prov."%' ORDER BY a.id DESC";	
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE c.nombre LIKE '%".$prov."%' GROUP BY a.id ORDER BY a.id DESC;";

			}else{
				//$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,IF(a.tipo_cambio='DOLAR',a.valor*a.valor_tipo_cambio,a.valor) as val_neg_pesos,d.t_pago_pesos,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT aa.id as id,bb.id as id_servicio,SUM(IF(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as t_pago_pesos FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY bb.id)as d ON d.id_servicio = a.id LEFT JOIN (SELECT id_negocio,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id_negocio) as e ON e.id_negocio = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_negocio = a.id ORDER BY a.id DESC";	
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id GROUP BY a.id ORDER BY a.id DESC;";			

			}
			
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			
			$sentencia->bind_result($fecha_pago,$id,$id_proveedor,$id_negocio,$f_crea,$valor,$tipo_cambio,$valor_tipo_cambio,$destino,$nombre,$rut,$valor_servicios,$pago_servicios);
			$arr = array();
			$i=0; 
			
			while ($sentencia->fetch()) {
				$arr[$i]['fecha_pago']=$fecha_pago;
				$arr[$i]['id']=$id;
				$arr[$i]['id_proveedor']=$id_proveedor;
				$arr[$i]['id_negocio']=$id_negocio;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['valor']=$valor;
				$arr[$i]['tipo_cambio']=$tipo_cambio;
				$arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr[$i]['destino']=$destino;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['rut']=$rut;
				$arr[$i]['valor_servicios']=$valor_servicios;
				$arr[$i]['pago_servicios']=$pago_servicios;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	public function getTarjetasPagosPag($nombre,$fechab,$pasajero){
		try{
			$conexion = Conectar::con();
			$registros_porp = 10;			
			$buscar='';
			
			if($nombre!=''){$buscar=$buscar."  AND  c.nombre LIKE '%".$nombre."%' OR c.apepat LIKE '%".$nombre."%'";}
			if($fechab!=''){$buscar=$buscar." AND a.fecha='".$fechab."'";}
			if($pasajero!=''){$buscar=$buscar." AND b.nombre_pasa_pri LIKE '%".$pasajero."%'";}

			$sql = "SELECT a.id as id_pago,b.id as id_negocio,b.valor_tipo_cambio,c.nombre,c.apepat,b.nombre_pasa_pri,b.destino,b.nota,a.fecha,a.monto,a.forma_pago,a.n_cuotas,a.cargo_transbank,a.total_cuota,a.tipo_moneda,IF(a.tipo_moneda='DOLAR',a.monto*b.valor_tipo_cambio,a.monto) as totalpesos,IF(a.tipo_moneda='DOLAR',(a.total_cuota*a.n_cuotas)*b.valor_tipo_cambio,a.total_cuota*a.n_cuotas) as recibidopesos FROM pagos_negocio_cli as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as c ON b.id_cliente=c.id WHERE a.forma_pago='TARJETA_CREDITO' ".$buscar." ORDER BY a.fecha DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	
	public function geTarjetasPagos($desde,$nombre,$fechab,$pasajero){
		try{
			$conexion = Conectar::con();	
			$buscar='';

			if($nombre!=''){$buscar=$buscar."  AND  c.nombre LIKE '%".$nombre."%' OR c.apepat LIKE '%".$nombre."%'";}
			if($fechab!=''){$buscar=$buscar." AND a.fecha='".$fechab."'";}
			if($pasajero!=''){$buscar=$buscar." AND b.nombre_pasa_pri LIKE '%".$pasajero."%'";}

			$sql = "SELECT a.id as id_pago,b.id as id_negocio,b.valor_tipo_cambio,c.nombre,c.apepat,b.nombre_pasa_pri,b.destino,b.nota,a.fecha,a.monto,a.forma_pago,a.n_cuotas,a.cargo_transbank,a.total_cuota,a.tipo_moneda,IF(a.tipo_moneda='DOLAR',a.monto*b.valor_tipo_cambio,a.monto) as totalpesos,IF(a.tipo_moneda='DOLAR',(a.total_cuota*a.n_cuotas)*b.valor_tipo_cambio,a.total_cuota*a.n_cuotas) as recibidopesos FROM pagos_negocio_cli as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN clientes as c ON b.id_cliente=c.id WHERE a.forma_pago='TARJETA_CREDITO' ".$buscar." ORDER BY a.fecha DESC LIMIT 10 OFFSET ?;";
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$desde);	
			$sentencia->execute();
			
			$sentencia->bind_result($id_pago,$id_negocio,$valor_tipo_cambio,$nombre,$apepat,$nombre_pasa_pri,$destino,$nota,$fecha,$monto,$forma_pago,$n_cuotas,$cargo_transbank,$total_cuota,$tipo_moneda,$totalpesos,$recibidopesos);
			$arr = array();
			$i=0; 
			while ($sentencia->fetch()) {
				$arr[$i]['id_pago']=$id_pago;
				$arr[$i]['id_negocio']=$id_negocio;
				$arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['apepat']=$apepat;
				$arr[$i]['nombre_pasa_pri']=$nombre_pasa_pri;
				$arr[$i]['destino']=$destino;
				$arr[$i]['nota']=$nota;
				$arr[$i]['fecha']=$fecha;
				$arr[$i]['monto']=$monto;
				$arr[$i]['forma_pago']=$forma_pago;
				$arr[$i]['n_cuotas']=$n_cuotas;
				$arr[$i]['cargo_transbank']=$cargo_transbank;
				$arr[$i]['total_cuota']=$total_cuota;
				$arr[$i]['tipo_moneda']=$tipo_moneda;
				$arr[$i]['totalpesos']=$totalpesos;
				$arr[$i]['recibidopesos']=$recibidopesos;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	public function getServiciosPagosFiltroPag($nombre,$fechab,$tipo){
		try{
			$conexion = Conectar::con();
			$registros_porp = 10;			
			$buscar='';
			
			if($nombre!=''){$buscar=$buscar."c.nombre LIKE '%".$nombre."%' AND ";}
			if($fechab!=''){$buscar=$buscar."a.fecha_pago='".$fechab."' AND ";}
			
			$fecha = date('Y-m-j');
			$nuevafecha = strtotime ( '+7 day' , strtotime ( $fecha ) ) ;
			$nuevafecha = date ( 'Y-m-j' , $nuevafecha );
			
			if($tipo=='pendientes'){
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND (f.pago_servicios is null OR f.pago_servicios='') GROUP BY a.id ORDER BY a.fecha_pago ASC;";	
			}
			
			if($tipo=='incompletos'){
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  ROUND(f.pago_servicios,2)<ROUND(e.valor_servicios,2) GROUP BY a.id ORDER BY a.fecha_pago ASC;";	
			}
			
			if($tipo=='pagados'){
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  ROUND(f.pago_servicios,2)>=ROUND(e.valor_servicios,2) GROUP BY a.id ORDER BY a.fecha_pago ASC;";	
			}
			
			
			if($tipo=='porvencer'){
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='' AND a.fecha_pago<='".$nuevafecha."' AND a.fecha_pago>='".$fecha."' AND (e.valor_servicios>0 AND ROUND(f.pago_servicios,2)<ROUND(e.valor_servicios,2) OR f.pago_servicios IS NUll) GROUP BY a.id ORDER BY a.fecha_pago ASC;";	
			}
			
			if($tipo=='vencidos'){
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='0000-00-00' AND a.fecha_pago<'".$fecha."' AND (e.valor_servicios>0 AND ROUND(f.pago_servicios,2)<ROUND(e.valor_servicios,2)) GROUP BY a.id ORDER BY a.fecha_pago ASC;";	
			}
			
			if($tipo=='sinfecha'){
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago='0000-00-00' AND e.valor_servicios>0 GROUP BY a.id ORDER BY a.id DESC;";	
			}
			
			
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	
	public function getServiciosPagosFiltro($desde,$nombre,$fechab,$tipo){
		try{
			$conexion = Conectar::con();	
			$buscar='';
			
			if($nombre!=''){$buscar=$buscar."c.nombre LIKE '%".$nombre."%' AND ";}
			if($fechab!=''){$buscar=$buscar."a.fecha_pago='".$fechab."' AND ";}
			
			$fecha = date('Y-m-j');
			$nuevafecha = strtotime ( '+7 day' , strtotime ( $fecha ) ) ;
			$nuevafecha = date ( 'Y-m-j' , $nuevafecha );
			
			if($tipo=='pendientes'){
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND (f.pago_servicios is null OR f.pago_servicios='') GROUP BY a.id ORDER BY a.fecha_pago ASC LIMIT 10 OFFSET ?;";	
			}
			
			if($tipo=='incompletos'){
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  ROUND(f.pago_servicios,2)<ROUND(e.valor_servicios,2) GROUP BY a.id ORDER BY a.fecha_pago ASC LIMIT 10 OFFSET ?;";	
			}
			
			if($tipo=='pagados'){
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  ROUND(f.pago_servicios,2)>=ROUND(e.valor_servicios,2) GROUP BY a.id ORDER BY a.fecha_pago ASC LIMIT 10 OFFSET ?;";	
			}
			
			
			if($tipo=='porvencer'){
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='' AND a.fecha_pago<='".$nuevafecha."' AND a.fecha_pago>='".$fecha."' AND (e.valor_servicios>0 AND ROUND(f.pago_servicios,2)<ROUND(e.valor_servicios,2) OR f.pago_servicios IS NUll) GROUP BY a.id ORDER BY a.fecha_pago ASC LIMIT 10 OFFSET ?;";	
			}
			
			if($tipo=='vencidos'){
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='0000-00-00' AND a.fecha_pago<'".$fecha."' AND (e.valor_servicios>0 AND ROUND(f.pago_servicios,2)<ROUND(e.valor_servicios,2)) GROUP BY a.id ORDER BY a.fecha_pago ASC LIMIT 10 OFFSET ?;";	
			}
			
			if($tipo=='sinfecha'){
				$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago='0000-00-00' AND e.valor_servicios>0  GROUP BY a.id ORDER BY a.id ASC LIMIT 10 OFFSET ?;";	
			}
			
			
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$desde);	
			$sentencia->execute();
			
			$sentencia->bind_result($fecha_pago,$id,$id_proveedor,$id_negocio,$f_crea,$valor,$tipo_cambio,$valor_tipo_cambio,$destino,$nombre,$rut,$valor_servicios,$pago_servicios);
			$arr = array();
			$i=0; 
			while ($sentencia->fetch()) {
				$arr[$i]['fecha_pago']=$fecha_pago;
				$arr[$i]['id']=$id;
				$arr[$i]['id_proveedor']=$id_proveedor;
				$arr[$i]['id_negocio']=$id_negocio;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['valor']=$valor;
				$arr[$i]['tipo_cambio']=$tipo_cambio;
				$arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				$arr[$i]['destino']=$destino;
				$arr[$i]['nombre']=$nombre;
				$arr[$i]['rut']=$rut;
				$arr[$i]['valor_servicios']=$valor_servicios;
				$arr[$i]['pago_servicios']=$pago_servicios;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	public function getServiciosPagosCount($nombre,$fechab){
		try{
			$conexion = Conectar::con();		
			$buscar='';
			$fecha = date('Y-m-j');
			$nuevafecha = strtotime ( '+7 day' , strtotime ( $fecha ) ) ;
			$nuevafecha = date ( 'Y-m-j' , $nuevafecha );
			
			if($nombre!=''){$buscar=$buscar."c.nombre LIKE '%".$nombre."%' AND ";}
			if($fechab!=''){$buscar=$buscar."a.fecha_pago='".$fechab."' AND ";}
			
			$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND (f.pago_servicios is null OR f.pago_servicios='') GROUP BY a.id ORDER BY a.fecha_pago ASC;";	
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$pendientes=$sentencia->num_rows;
			
			$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  ROUND(f.pago_servicios,2)<ROUND(e.valor_servicios,2) GROUP BY a.id ORDER BY a.fecha_pago ASC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$incompletos=$sentencia->num_rows;
			
			$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  ROUND(f.pago_servicios,2)>=ROUND(e.valor_servicios,2) GROUP BY a.id ORDER BY a.fecha_pago ASC;";		
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$pagados=$sentencia->num_rows;
			
			$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='' AND a.fecha_pago<='".$nuevafecha."' AND a.fecha_pago>='".$fecha."' AND (e.valor_servicios>0 AND ROUND(f.pago_servicios,2)<ROUND(e.valor_servicios,2) OR f.pago_servicios IS NUll) GROUP BY a.id ORDER BY a.fecha_pago ASC;";	
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$porvencer=$sentencia->num_rows;
			
			$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='0000-00-00' AND a.fecha_pago<'".$fecha."' AND (e.valor_servicios>0 AND ROUND(f.pago_servicios,2)<ROUND(e.valor_servicios,2)) GROUP BY a.id ORDER BY a.fecha_pago ASC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$vencidos=$sentencia->num_rows;
			
			$sql = "SELECT a.fecha_pago,a.id,a.id_proveedor,a.id_negocio,a.f_crea,a.valor,a.tipo_cambio,a.valor_tipo_cambio,b.destino,c.nombre,c.rut,e.valor_servicios,f.pago_servicios FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago='0000-00-00' AND e.valor_servicios>0 GROUP BY a.id ORDER BY a.id DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$sinfecha=$sentencia->num_rows;
			
			return array('pendientes'=>$pendientes,'incompletos'=>$incompletos,'pagados'=>$pagados,'porvencer'=>$porvencer,'vencidos'=>$vencidos,'sinfecha'=>$sinfecha);
			
			$conexion->close();
			$sentencia->close();
			
			
			
			
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	public function getServiciosPagosTotales($nombre,$fechab){
		try{
			$conexion = Conectar::con();		
			$buscar='';
			$fecha = date('Y-m-j');
			$nuevafecha = strtotime ( '+7 day' , strtotime ( $fecha ) ) ;
			$nuevafecha = date ( 'Y-m-j' , $nuevafecha );
			
			$pendientes=0;
			$incompletos =0;
			$pagados =0;
			$vencidos =0;
			$sinfecha =0;
			$porvencer =0;
			
			if($nombre!=''){$buscar=$buscar."c.nombre LIKE '%".$nombre."%' AND ";}
			if($fechab!=''){$buscar=$buscar."a.fecha_pago='".$fechab."' AND ";}
			
			$sql = "SELECT ROUND(sum(e.valor_servicios),2) as deuda FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND (f.pago_servicios is null OR f.pago_servicios='') ORDER BY a.id DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($deuda);
			$valor=0;
			while ($sentencia->fetch()) {
				$pendientes=$deuda;
			}
			
			$sql = "SELECT ROUND(sum(e.valor_servicios-f.pago_servicios),2) as deuda FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  f.pago_servicios<e.valor_servicios ORDER BY a.id DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($deuda);
			$valor=0;
			while ($sentencia->fetch()) {
				$incompletos=$deuda;
			}
			
			$sql = "SELECT ROUND(sum(f.pago_servicios),2) as pago FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." e.valor_servicios>0 AND f.pago_servicios>0 AND  f.pago_servicios>=e.valor_servicios  ORDER BY a.id DESC;";	
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($pago);
			$valor=0;
			while ($sentencia->fetch()) {
				$pagados=$pago;
			}

			$sql = "SELECT ROUND(sum(e.valor_servicios)-sum(if(f.pago_servicios is not null,f.pago_servicios,0)),2) as deuda FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='' AND a.fecha_pago<='".$nuevafecha."' AND a.fecha_pago>='".$fecha."' AND (e.valor_servicios>0 AND f.pago_servicios<e.valor_servicios OR f.pago_servicios IS NUll) ORDER BY a.id DESC;";	
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($deuda);
			$valor=0;
			while ($sentencia->fetch()) {
				$porvencer=$deuda;
			}
	
			$sql = "SELECT ROUND(sum(e.valor_servicios)-sum(if(f.pago_servicios is not null,f.pago_servicios,0)),2) as deuda FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago!='0000-00-00' AND a.fecha_pago<'".$fecha."' AND (e.valor_servicios>0 AND f.pago_servicios<e.valor_servicios) ORDER BY a.id DESC;";	
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($deuda);
			$valor=0;
			while ($sentencia->fetch()) {
				$vencidos=$deuda;
			}
			
			
			$sql = "SELECT ROUND(sum(e.valor_servicios)-sum(if(f.pago_servicios is not null,f.pago_servicios,0)),2) as deuda FROM servicios_negocios as a LEFT JOIN negocios as b ON a.id_negocio=b.id LEFT JOIN proveedores as c ON a.id_proveedor=c.id LEFT JOIN (SELECT id,id_negocio,id_proveedor,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as valor_servicios FROM servicios_negocios GROUP BY id) as e ON e.id = a.id LEFT JOIN (SELECT aa.id_servicio,bb.id_negocio as id_negocio ,SUM(if(aa.tipo_moneda='DOLAR',aa.monto*bb.valor_tipo_cambio,aa.monto)) as pago_servicios FROM pagos_serv as aa LEFT JOIN servicios_negocios as bb ON aa.id_servicio=bb.id GROUP BY aa.id_servicio) as f ON f.id_servicio = a.id WHERE ".$buscar." a.fecha_pago='0000-00-00' AND e.valor_servicios>0 AND (f.pago_servicios<e.valor_servicios) ORDER BY a.id DESC;";	
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($deuda);
			$valor=0;
			while ($sentencia->fetch()) {
				$sinfecha=$deuda;
			}
			
			return array('pendientes'=>$pendientes,'incompletos'=>$incompletos,'pagados'=>$pagados,'porvencer'=>$porvencer,'vencidos'=>$vencidos,'sinfecha'=>$sinfecha);
			
			$conexion->close();
			$sentencia->close();
			
			
			
			
			
			
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	
	
	
	
	public function getNRealizados($id){
		try{
		
		$conexion = Conectar::con();			
			//$sql = "SELECT COUNT(a.id) AS contador,if(a.tipo_cambio='DOLAR',a.valor_tipo_cambio*a.precio,a.precio) as valor,b.pagospesos,MONTH(a.f_crea) AS mes,YEAR(a.f_crea) AS ano FROM negocios as a LEFT JOIN(SELECT c.id_negocio,SUM(if(c.tipo_moneda='DOLAR',c.monto*d.valor_tipo_cambio,c.monto)) as pagospesos FROM pagos_negocio_cli as c LEFT JOIN negocios as d ON c.id_negocio=d.id GROUP BY c.id_negocio) as b ON b.id_negocio=a.id WHERE a.f_crea >= date_sub(curdate(), interval 6 month)  AND a.id_us_crea=? GROUP BY MONTH(a.f_crea) ORDER BY ano DESC,mes DESC;";

			$sql = "SELECT COUNT(a.id) AS contador,if(a.tipo_cambio='DOLAR',a.valor_tipo_cambio*a.precio,a.precio) as valor,b.pagospesos,d.servpesos,e.servpesospagos,MONTH(a.f_crea) AS mes,YEAR(a.f_crea) AS ano FROM negocios as a LEFT JOIN (SELECT MONTH(c.fecha) as fecha,SUM(if(c.tipo_moneda='DOLAR',c.monto*d.valor_tipo_cambio,c.monto)) as pagospesos FROM pagos_negocio_cli as c LEFT JOIN negocios as d ON c.id_negocio=d.id WHERE c.id_us_crea=".$id." GROUP BY MONTH(c.fecha)) as b ON MONTH(a.f_crea)=b.fecha LEFT JOIN(SELECT MONTH(f_crea) as fecha,SUM(if(tipo_cambio='DOLAR',valor*valor_tipo_cambio,valor)) as servpesos FROM servicios_negocios WHERE id_us_crea=".$id." GROUP BY MONTH(f_crea)) as d  ON MONTH(a.f_crea)=d.fecha LEFT JOIN(SELECT MONTH(a.fecha) as fecha,SUM(if(a.tipo_moneda='DOLAR',a.monto*b.valor_tipo_cambio,a.monto)) as servpesospagos FROM pagos_serv as a LEFT JOIN servicios_negocios as b ON a.id_servicio=b.id WHERE a.id_us_crea=".$id." GROUP BY MONTH(a.fecha)) as e  ON MONTH(a.f_crea)=e.fecha WHERE a.f_crea >= date_sub(curdate(), interval 6 month) AND a.id_us_crea=".$id." GROUP BY MONTH(a.f_crea) ORDER BY ano DESC,mes DESC;";			
			
			$sentencia = $conexion->prepare($sql);
			//$sentencia->bind_param("i",$id);
			$sentencia->execute();
			$sentencia->bind_result($contador,$valor,$pagospesos,$servpesos,$servpesospagos,$mes,$ano);
			$arr = array();
			$i=0; 
			
			while ($sentencia->fetch()) {
				$arr[$i]['contador']=$contador;
				$arr[$i]['valor']=$valor;
				$arr[$i]['pagospesos']=$pagospesos;
				$arr[$i]['servpesos']=$servpesos;
				$arr[$i]['servpesospagos']=$servpesospagos;
				$arr[$i]['mes']=$mes;
				$arr[$i]['ano']=$ano;
				$i++;
			}
			return $arr;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	
	public function validaFGasto($fecha){
		try{
			$conexion = Conectar::con();
			$fecha=$fecha.'-00';
			$sql = "SELECT * FROM gastos where mes_gasto=?;";
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("s",$fecha);		
			$sentencia->execute();
			
			$sentencia->store_result();
			return $sentencia->num_rows;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	public function udtGasto($datos){
		$conexion = Conectar::con();
		$id_cheque='';
		$rutgirador='76.006.128-K';
		$nombre_girador='EMPRESA DE TURISMO CHILETOURS LTDA.';
		$banco='BANCO DE CHILE';
		$n_cuenta='159-22041-06';
		$pax='';
		
		
		if($datos['forma_pago']=='CHEQUE_DIA' || $datos['forma_pago']=='CHEQUE_FECHA'){
			if($datos['id_cheque']!=''){
				/*Modifica cheque*/
				$sql="UPDATE cheques SET rut_girador=?,nombre_girador=?,banco=?,n_cuenta=?,n_cheque=?,monto=?,fecha_cobro=?,pax=? WHERE id=?;";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("ssssssssi",$rutgirador,$nombre_girador,$banco,$n_cuenta,$datos['n_cheque'],$datos['monto'],$datos['fecha_cobro'],$pax,$datos['id_cheque']);
				$sentencia->execute();
				$id_cheque=$datos['id_cheque'];
			}else{
				/*Crea cheque*/	
				$nom_tabla='gastos';
				$estado='emitido';
				$tipo_cuenta='PESO';
				$tipo_cheque='girado';
				
				$sql = "INSERT INTO cheques(id_us_crea,fecha_crea,id_tabla_aso,nom_tabla,rut_girador,nombre_girador,banco,n_cuenta,n_cheque,monto,fecha_cobro,estado,pax,tipo_cuenta,tipo_cheque) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("isissssssssssss",$datos['id_us_crea'],$datos['f_crea'],$datos['id'],$nom_tabla,$rutgirador,$nombre_girador,$banco,$n_cuenta,$datos['n_cheque'],$datos['monto'],$datos['fecha_cobro'],$estado,$pax,$tipo_cuenta,$tipo_cheque);
				$sentencia->execute();
				
				if ($sentencia->errno) {
					return "fallo!!! " . $sentencia->error;
				}else{
					$id_cheque=$conexion->insert_id;
					$sql="UPDATE gastos SET id_cheque=? WHERE id=?;";
					$sentencia = $conexion->prepare($sql);
					$sentencia->bind_param("ii",$id_cheque,$datos['id']);
					$sentencia->execute();
				}
				
			}	
		}
		
		if($datos['forma_pago']!='CHEQUE_DIA' && $datos['forma_pago']!='CHEQUE_FECHA' && $datos['id_cheque']!=''){
			/*Borra cheque*/
			$sql = "DELETE FROM cheques WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$datos['id_cheque']);
			$sentencia->execute();
		}
		
		$sql="UPDATE gastos SET tipo=?,razon=?,monto=?,forma_pago=?,n_cheque=?,f_ingreso=?,detalleefe=? WHERE id=?;";
		$sentencia = $conexion->prepare($sql);
		$sentencia->bind_param("sssssssi",$datos['tipo'],$datos['razon'],$datos['monto'],$datos['forma_pago'],$datos['n_cheque'],$datos['f_ingreso'],$datos['detalleefe'],$datos['id']);
		$sentencia->execute();
		
		
		if ($sentencia->errno) {
			return "fallo!!! " . $sentencia->error;
		}else {
			return	array($sentencia->affected_rows,$id_cheque);
		}
		
		$conexion->close();
        $sentencia->close();
		
		
	}
	
	public function creaGasto($datos){
		try{
			$rutgirador='76.006.128-K';
			$nombre_girador='EMPRESA DE TURISMO CHILETOURS LTDA.';
			$banco='BANCO DE CHILE';
			$n_cuenta='159-22041-06';
			$pax='';
			$id_cheque='';
			
			$conexion = Conectar::con();
			$sql = "INSERT INTO gastos(f_crea,mes_gasto,tipo,razon,monto,forma_pago,n_cheque,empresa,f_ingreso,detalleefe,f_deposito) VALUES(?,?,?,?,?,?,?,?,?,?,?);";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("sssssssssss",$datos['f_crea'],$datos['mes_gasto'],$datos['tipo'],$datos['razon'],$datos['monto'],$datos['forma_pago'],$datos['n_cheque'],$datos['empresa'],$datos['f_ingreso'],$datos['detalleefe'],$datos['f_deposito']);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				$id_creado=$conexion->insert_id;
				if($datos['forma_pago']=='CHEQUE_DIA' || $datos['forma_pago']=='CHEQUE_FECHA'){
				
					$nom_tabla='gastos';
					$estado='emitido';
					$tipo_cuenta='PESO';
					$tipo_cheque='girado';
					
					$sql = "INSERT INTO cheques(id_us_crea,fecha_crea,id_tabla_aso,nom_tabla,rut_girador,nombre_girador,banco,n_cuenta,n_cheque,monto,fecha_cobro,estado,pax,tipo_cuenta,tipo_cheque) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
					$sentencia = $conexion->prepare($sql);
					$sentencia->bind_param("isissssssssssss",$datos['id_us_crea'],$datos['f_crea'],$id_creado,$nom_tabla,$rutgirador,$nombre_girador,$banco,$n_cuenta,$datos['n_cheque'],$datos['monto'],$datos['fecha_cobro'],$estado,$pax,$tipo_cuenta,$tipo_cheque);
					$sentencia->execute();
					
					if ($sentencia->errno) {
						return "fallo!!! " . $sentencia->error;
					}else{
						$id_cheque=$conexion->insert_id;
						$sql="UPDATE gastos SET id_cheque=? WHERE id=?;";
						$sentencia = $conexion->prepare($sql);
						$sentencia->bind_param("ii",$id_cheque,$id_creado);
						$sentencia->execute();
					}
				}
			}
			
			return array('id'=>$id_creado,'id_cheque'=>$id_cheque);
			
			$conexion->close();
            $sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	}
	
	public function getGastos($fecha){
		try{
			$conexion = Conectar::con();
			//$sql = "SELECT id,f_crea,mes_gasto,tipo,monto,n_cheque,id_cheque,forma_pago,razon,empresa,f_ingreso FROM gastos WHERE mes_gasto=? ORDER BY id ASC;"; 
			$sql = "SELECT f_deposito,detalleefe,id,f_crea,f_ingreso,tipo,monto,n_cheque,id_cheque,forma_pago,razon,empresa,f_ingreso FROM gastos WHERE YEAR(f_ingreso)='".$fecha."'  AND month(f_ingreso)=month('".$fecha."') ORDER BY id DESC;";
			
			$sentencia = $conexion->prepare($sql);
			//$sentencia->bind_param('s',$fecha);
			$sentencia->execute();
			
			$sentencia->bind_result($f_deposito,$detalleefe,$id,$f_crea,$mes_gasto,$tipo,$monto,$n_cheque,$id_cheque,$forma_pago,$razon,$empresa,$f_ingreso);
			$arr = array();
			$i=0; 
			 while ($sentencia->fetch()) {
				$arr[$i]['id']=$id;
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['mes_gasto']=$mes_gasto;
				$arr[$i]['tipo']=$tipo;
				$arr[$i]['monto']=$monto;
				$arr[$i]['id_cheque']=$id_cheque;
				$arr[$i]['n_cheque']=$n_cheque;
				$arr[$i]['forma_pago']=$forma_pago;
				$arr[$i]['razon']=$razon;
				$arr[$i]['empresa']=$empresa;
				$arr[$i]['f_ingreso']=$f_ingreso;
				$arr[$i]['detalleefe']=$detalleefe;
				$arr[$i]['f_deposito']=$f_deposito;
				
				
				$i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	public function borrarGasto($id){
		try{
			$id=$id;
			$conexion = Conectar::con();
			$sql = "SELECT id_cheque FROM gastos WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("s",$id);		
			$sentencia->execute();
			$sentencia->bind_result($cheque);
			
			
			while ($sentencia->fetch()) {
				if($cheque>0 || $cheque!=''){
					$conexion = Conectar::con();
					$sql = "DELETE FROM cheques WHERE id=? AND nom_tabla='gastos';";
					$sentencia = $conexion->prepare($sql);
					$sentencia->bind_param("i",$cheque);
					$sentencia->execute();
				}
			}
			
		
			$sql = "DELETE FROM gastos WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			if ($sentencia->errno) {
				return "fallo!!! " . $sentencia->error;
			}else {
				return	$sentencia->affected_rows;
			}
		
		
		}catch(Exception $e){
			echo $e;
			$conexion->close();
			$sentencia->close();
			return false;
		}
	}	
	
	
	public function getGastosMesesPaginas(){
		try{
			$registros_porp = 10;
			$conexion = Conectar::con();
			//$sql = "SELECT f_crea,mes_gasto,sum(monto) as total FROM gastos GROUP BY mes_gasto ORDER BY mes_gasto DESC;";
			$sql = "SELECT f_crea,f_ingreso,sum(monto) as total,sum(if(tipo='fijo',monto,0)) as tfijo,sum(if(tipo='variable',monto,0)) as tvariable,sum(if(tipo='bancarios',monto,0)) as tbancario,sum(if(tipo='boleta_honorarios',monto,0)) as tboleta,sum(if(tipo='factura',monto,0)) as tfactura,CONCAT(YEAR(f_ingreso),'-',LPAD(MONTH(f_ingreso), 2, '0')) as mesano FROM gastos GROUP BY mesano ORDER BY mesano DESC;";
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->store_result();
			$total_registros = $sentencia->num_rows;
			
			$total_paginas = ceil($total_registros/$registros_porp);
		
			return $total_paginas;
			
			$conexion->close();
			$sentencia->close();
		
		}catch(Exception $e){
            echo $e;
            $conexion->close();
            $sentencia->close();
            return false;
        }
	}
	
	public function getGastosMeses($pagina){
		try{
			$conexion = Conectar::con();
			//$sql = "SELECT f_crea,mes_gasto,sum(monto) as total FROM gastos GROUP BY mes_gasto ORDER BY mes_gasto DESC LIMIT 10 OFFSET ?;";
			$sql = "SELECT f_crea,f_ingreso,sum(monto) as total,sum(if(tipo='fijo',monto,0)) as tfijo,sum(if(tipo='variable',monto,0)) as tvariable,sum(if(tipo='bancarios',monto,0)) as tbancario,sum(if(tipo='boleta_honorarios',monto,0)) as tboleta,sum(if(tipo='factura',monto,0)) as tfactura,CONCAT(YEAR(f_ingreso),'-',LPAD(MONTH(f_ingreso), 2, '0')) as mesano FROM gastos GROUP BY mesano ORDER BY mesano DESC LIMIT 10 OFFSET ?;";
			
			
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$desde);
			$sentencia->execute();
			
			
			$sentencia->bind_result($f_crea,$f_ingreso,$total,$tfijo,$tvariable,$tbancario,$tboleta,$tfactura,$mesano);
			$arr = array();
			$i=0; 
			 while ($sentencia->fetch()) {
				$arr[$i]['f_crea']=$f_crea;
				$arr[$i]['f_ingreso']=$f_ingreso;
				$arr[$i]['total']=$total;
				$arr[$i]['tfijo']=$tfijo;
				$arr[$i]['tvariable']=$tvariable;
				$arr[$i]['tbancario']=$tbancario;
				$arr[$i]['tboleta']=$tboleta;
				$arr[$i]['tfactura']=$tfactura;
				$arr[$i]['mesano']=$mesano;
				$i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	
	public function getCheque($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,id_tabla_aso,nom_tabla,rut_girador,nombre_girador,banco,n_cuenta,n_cheque,monto,fecha_cobro,pax FROM cheques WHERE nom_tabla='gastos' AND id_tabla_aso=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			$sentencia->bind_result($id,$id_tabla_aso,$nom_tabla,$rut_girador,$nombre_girador,$banco,$n_cuenta,$n_cheque,$monto,$fecha_cobro,$pax);
			$arr = array();
			
			 while ($sentencia->fetch()) {
				$arr['id']=$id;
				$arr['id_tabla_aso']=$id_tabla_aso;
				$arr['nom_tabla']=$nom_tabla;
				$arr['rut_girador']=$rut_girador;
				$arr['nombre_girador']=$nombre_girador;
				$arr['banco']=$banco;
				$arr['n_cuenta']=$n_cuenta;
				$arr['n_cheque']=$n_cheque;
				$arr['monto']=$monto;
				$arr['fecha_cobro']=$fecha_cobro;
				$arr['pax']=$pax;				 
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
		
	}
	
	public function getChequeVer($id){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,id_tabla_aso,nom_tabla,rut_girador,nombre_girador,banco,n_cuenta,n_cheque,monto,fecha_cobro,pax FROM cheques WHERE id=?;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->bind_param("i",$id);
			$sentencia->execute();
			
			$sentencia->bind_result($id,$id_tabla_aso,$nom_tabla,$rut_girador,$nombre_girador,$banco,$n_cuenta,$n_cheque,$monto,$fecha_cobro,$pax);
			$arr = array();
			
			 while ($sentencia->fetch()) {
				$arr['id']=$id;
				$arr['id_tabla_aso']=$id_tabla_aso;
				$arr['nom_tabla']=$nom_tabla;
				$arr['rut_girador']=$rut_girador;
				$arr['nombre_girador']=$nombre_girador;
				$arr['banco']=$banco;
				$arr['n_cuenta']=$n_cuenta;
				$arr['n_cheque']=$n_cheque;
				$arr['monto']=$monto;
				$arr['fecha_cobro']=$fecha_cobro;
				$arr['pax']=$pax;				 
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
		
	}
	
	public function getGastosTotal(){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT (YEAR(f_ingreso))AS ano,sum(monto) as total FROM gastos GROUP BY YEAR(f_ingreso) ORDER BY YEAR(f_ingreso) DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			
			$sentencia->bind_result($ano,$total);
			$arr = array();
			$i=0; 
			 while ($sentencia->fetch()) {
				$arr[$i]['ano']=$ano;
				$arr[$i]['total']=$total;
				$i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	
	
	public function enviaGastoCorreo($mesgasto,$correo,$tabla){
		try{
			$para = $correo;
			$titulo = $mesgasto.' I-Travel';
			$mensaje='<html>';
			$mensaje .='<head><title>I-travel</title></head>';
			$mensaje .='<body>';
			$mensaje .='A continuación e muestran los gastos a la fecha de: '.$mesgasto.'<br><br>'; 
			$mensaje .=$tabla.'<br><br>';
			$mensaje .='Atentamente, <br>Administración<br></body>';
			$cabeceras  = 'MIME-Version: 1.0' . "\r\n";
			$cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
			$cabeceras .= 'From: I-Travel Web <itravel@noresponder.com>' . "\r\n";
			if (mail($para, $titulo, $mensaje, $cabeceras)) {
				return 1;
			} else {
				return 0;
			}
		
		
		}catch(Exception $e){
            echo $e;
            return false;
        }
	
	}
	
	
	
	
	public function negocios(){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT id,id_us_crea,id_cliente,tipo_cuenta,precio,valor_tipo_cambio,tipo_cambio,f_ingreso_neg,if(tipo_cambio='DOLAR',(precio*valor_tipo_cambio),precio) as ppesos  FROM negocios ORDER BY f_ingreso_neg DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($id,$id_us_crea,$id_cliente,$tipo_cuenta,$precio,$valor_tipo_cambio,$tipo_cambio,$f_ingreso_neg,$ppesos);
			$arr = array();
			$i=0; 
			 while ($sentencia->fetch()) {
				 $arr[$i]['id']=$id;
				 $arr[$i]['id_us_crea']=$id_us_crea;
				 $arr[$i]['id_cliente']=$id_cliente;
				 $arr[$i]['tipo_cuenta']=$tipo_cuenta;
				 $arr[$i]['precio']=$precio;
				 $arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				 $arr[$i]['tipo_cambio']=$tipo_cambio;
				 $arr[$i]['f_ingreso_neg']=$f_ingreso_neg;
				 $arr[$i]['ppesos']=$ppesos;
				$i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	
	public function pagosCliente(){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT a.id,a.id_negocio,a.fecha,a.monto,a.tipo_moneda,if(a.tipo_moneda='DOLAR',(a.monto*b.valor_tipo_cambio),a.monto) as ppesos FROM pagos_negocio_cli AS a LEFT JOIN negocios AS b ON a.id_negocio=b.id;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($id,$id_negocio,$fecha,$monto,$tipo_moneda,$ppesos);
			$arr = array();
			$i=0; 
			 while ($sentencia->fetch()) {
				  $arr[$i]['id']=$id;
				  $arr[$i]['id_negocio']=$id_negocio;
				  $arr[$i]['fecha']=$fecha;
				  $arr[$i]['monto']=$monto;
				  $arr[$i]['tipo_moneda']=$tipo_moneda;
				  $arr[$i]['ppesos']=$ppesos;
				$i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	
	public function pagosServicios(){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT a.id,b.id_proveedor,b.f_crea,b.fecha_pago,b.valor_tipo_cambio,b.valor,if(b.tipo_cambio='DOLAR',(b.valor*b.valor_tipo_cambio),b.valor) as ppesos,a.monto,a.tipo_moneda,if(a.tipo_moneda='DOLAR',(a.monto*b.valor_tipo_cambio),a.monto) as ppesospago FROM pagos_serv as a LEFT JOIN servicios_negocios as b ON a.id_servicio=b.id;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($id,$id_proveedor,$f_crea_serv,$fecha_pago,$valor_tipo_cambio,$valorservv,$servppesos,$pagomonto,$pagotipo_moneda,$pagoppesospago	);
			$arr = array();
			$i=0; 
			 while ($sentencia->fetch()) {
				  $arr[$i]['id']=$id;
				  $arr[$i]['id_proveedor']=$id_proveedor;
				  $arr[$i]['f_crea_serv']=$f_crea_serv;
				  $arr[$i]['fecha_pago']=$fecha_pago;
				  $arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				  $arr[$i]['valorservv']=$valorservv;
				  $arr[$i]['servppesos']=$servppesos;
				  $arr[$i]['pagomonto']=$pagomonto;
				  $arr[$i]['pagotipo_moneda']=$pagotipo_moneda;
				  $arr[$i]['pagoppesospago']=$pagoppesospago;				 
				$i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	public function negociosGroup(){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT COUNT(id) AS contador,id,precio,valor_tipo_cambio,tipo_cambio,f_ingreso_neg,MONTH(f_ingreso_neg) AS mes,YEAR(f_ingreso_neg) AS ano ,if(tipo_cambio='DOLAR',(precio*valor_tipo_cambio),precio) as ppesos  FROM negocios WHERE f_ingreso_neg >= date_sub(curdate(), interval 6 month) GROUP BY MONTH(f_ingreso_neg) ORDER BY ano DESC,mes DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($contador,$id,$precio,$valor_tipo_cambio,$tipo_cambio,$f_ingreso_neg,$mes,$ano,$ppesos);
			$arr = array();
			$i=0; 
			 while ($sentencia->fetch()) {
				 $arr[$i]['contador']=$contador;
				 $arr[$i]['id']=$id;
				 $arr[$i]['precio']=$precio;
				 $arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				 $arr[$i]['tipo_cambio']=$tipo_cambio;
				 $arr[$i]['f_ingreso_neg']=$f_ingreso_neg;
				 $arr[$i]['mes']=$mes;
				 $arr[$i]['ano']=$ano;
				 $arr[$i]['ppesos']=$ppesos;
				$i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	
	
	public function pagosClienteGroup(){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT COUNT(a.id) AS contador,a.id,a.id_negocio,a.fecha,a.monto,a.tipo_moneda,MONTH(a.fecha) AS mes,YEAR(a.fecha) AS ano ,if(a.tipo_moneda='DOLAR',(a.monto*b.valor_tipo_cambio),a.monto) as ppesos FROM pagos_negocio_cli AS a LEFT JOIN negocios AS b ON a.id_negocio=b.id WHERE a.fecha >= date_sub(curdate(), interval 6 month)  GROUP BY MONTH(a.fecha) ORDER BY ano DESC,mes DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();
			$sentencia->bind_result($contador,$id,$id_negocio,$fecha,$monto,$tipo_moneda,$mes,$ano,$ppesos);
			$arr = array();
			$i=0; 
			 while ($sentencia->fetch()) {
				 $arr[$i]['contador']=$contador;
				 $arr[$i]['id']=$id;
				 $arr[$i]['id_negocio']=$id_negocio;
				 $arr[$i]['fecha']=$fecha;
				 $arr[$i]['monto']=$monto;
				 $arr[$i]['tipo_moneda']=$tipo_moneda;
				 $arr[$i]['mes']=$mes;
				 $arr[$i]['ano']=$ano;
				 $arr[$i]['ppesos']=$ppesos;
				$i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	
	public function pagosServiciosGroup(){
		try{
			$conexion = Conectar::con();
			$sql = "SELECT COUNT(a.id) AS contador,a.id,b.fecha_pago,b.valor_tipo_cambio,b.valor,if(b.tipo_cambio='DOLAR',(b.valor*b.valor_tipo_cambio),b.valor) as ppesos,a.monto,a.tipo_moneda,if(a.tipo_moneda='DOLAR',(a.monto*b.valor_tipo_cambio),a.monto) as ppesospago,MONTH(if(b.fecha_pago='0000-00-00' OR b.fecha_pago='' ,b.f_crea,b.fecha_pago)) AS mes,YEAR(if(b.fecha_pago='0000-00-00' OR b.fecha_pago='' ,b.f_crea,b.fecha_pago)) AS ano FROM pagos_serv as a LEFT JOIN servicios_negocios as b ON a.id_servicio=b.id GROUP BY MONTH(b.fecha_pago) ORDER BY ano DESC,mes DESC;";
			$sentencia = $conexion->prepare($sql);
			$sentencia->execute();

			$sentencia->bind_result($contador,$id,$fecha_pago,$valor_tipo_cambio,$valor,$ppesos,$monto,$tipo_moneda,$ppesospago,$mes,$ano);
			$arr = array();
			$i=0; 
			 while ($sentencia->fetch()) {
				 $arr[$i]['contador']=$contador;
				 $arr[$i]['id']=$id;
				 $arr[$i]['fecha_pago']=$fecha_pago;
				 $arr[$i]['valor_tipo_cambio']=$valor_tipo_cambio;
				 $arr[$i]['valor']=$valor;
				 $arr[$i]['ppesos']=$ppesos;
				 $arr[$i]['monto']=$monto;
				 $arr[$i]['tipo_moneda']=$tipo_moneda;
				 $arr[$i]['ppesospago']=$ppesospago;
				 $arr[$i]['mes']=$mes;
				 $arr[$i]['ano']=$ano;			 
				$i++;
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	
	public function EnviarSaludos($fecha_cumple,$todos,$inicio,$cuerpo){	
		try{
			
			$conexion = Conectar::con();
			
			if($todos=='SI'){
				$sql = "SELECT nombre,apepat,apemat,email FROM clientes";
				$sentencia = $conexion->prepare($sql);
				$sentencia->execute();
				$sentencia->bind_result($nombre,$apepat,$apemat,$email);

				 while ($sentencia->fetch()) {
					 if($email!=''){
						$para = $email;
						$titulo = 'I-Travel | CYM Tours';
						$mensaje='<html>';
						$mensaje .='<head><title>I-Travel | CYM Tours</title></head>';
						$mensaje .='<body>';
						$mensaje .=$inicio.' '.$nombre.' '.$apepat.' '.$apemat.'</b><br>';
						$mensaje .=$cuerpo.'<br>';
						$mensaje .='Atentamente, <br>I-Travel | CYM Tours<br></body>';
						
						$cabeceras  = 'MIME-Version: 1.0' . "\r\n";
						$cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
						$cabeceras .= 'From: I-Travel Web <itravel@noresponder.com>' . "\r\n";
						
						mail($para, $titulo, $mensaje, $cabeceras);
					 }
				}
			}else{
				$timestamp = strtotime($fecha_cumple);
				$mes=date("m", $timestamp);
				$dia=date("d", $timestamp);
				$sql = "SELECT nombre,apepat,apemat,email FROM clientes WHERE MONTH(f_nac)=? AND DAY(f_nac)=?;";
				$sentencia = $conexion->prepare($sql);
				$sentencia->bind_param("ss",$mes,$dia);
				$sentencia->execute();
				$sentencia->bind_result($nombre,$apepat,$apemat,$email);

				 while ($sentencia->fetch()) {
					 if($email!=''){
						 $para = $email;
						 $titulo = 'I-Travel | CYM Tours';
						 $mensaje='<html>';
						 $mensaje .='<head><title>I-Travel | CYM Tours</title></head>';
						 $mensaje .='<body>';
						 $mensaje .=$inicio.' '.$nombre.' '.$apepat.' '.$apemat.'</b><br>';
						 $mensaje .=$cuerpo.'<br>';
						 $mensaje .='Atentamente, <br>I-Travel | CYM Tours<br></body>';
						
						 $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
						 $cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
						 $cabeceras .= 'From: I-Travel Web <itravel@noresponder.com>' . "\r\n";
						
						 mail($para, $titulo, $mensaje, $cabeceras);
					 }
				}
				
			}

			$conexion->close();
			$sentencia->close();
			return $arr;
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	
	public function contarEstaNE(){
		try{
			$conexion = Conectar::con();
			$arr1 = array();
			$arr2 = array();
			$i=0;
			
			$sql1="SELECT COUNT(*) as total FROM negocios;";
			$sql2="SELECT COUNT(b.id) as total,a.nombre,a.apepat  FROM usuarios as a LEFT JOIN negocios as b ON b.id_us_crea=a.id WHERE a.id<>1 GROUP BY a.id;";
			
			
			$sentencia1 = $conexion->prepare($sql1);
			$sentencia1->execute();
			$sentencia1->bind_result($contar);
			while ($sentencia1->fetch()) {	
				$arr1['contar']=$contar;	
			}
			
			$sentencia2 = $conexion->prepare($sql2);
			$sentencia2->execute();
			$sentencia2->bind_result($total,$nombre,$apepat);
			while ($sentencia2->fetch()) {	
				$arr2[$i]['total']=$total;
				$arr2[$i]['nombre']=$nombre;
				$arr2[$i]['apepat']=$apepat;
				$i++;
			}

			$conexion->close();
			$sentencia1->close();
			$sentencia2->close();
			return array('contar'=>$arr1,'contar_us'=>$arr2);
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	
	
	public function contarEstaCli(){
		try{
			$conexion = Conectar::con();
			$arr1 = array();
			$arr2 = array();
			$i=0;
			
			$sql1="SELECT COUNT(*) as total FROM pagos_negocio_cli;";
			$sql2="SELECT COUNT(b.id) as total,a.nombre,a.apepat  FROM usuarios as a LEFT JOIN pagos_negocio_cli as b ON b.id_us_crea=a.id WHERE a.id<>1 GROUP BY a.id;";
			
			
			$sentencia1 = $conexion->prepare($sql1);
			$sentencia1->execute();
			$sentencia1->bind_result($contar);
			while ($sentencia1->fetch()) {	
				$arr1['contar']=$contar;	
			}
			
			$sentencia2 = $conexion->prepare($sql2);
			$sentencia2->execute();
			$sentencia2->bind_result($total,$nombre,$apepat);
			while ($sentencia2->fetch()) {	
				$arr2[$i]['total']=$total;
				$arr2[$i]['nombre']=$nombre;
				$arr2[$i]['apepat']=$apepat;
				$i++;
			}

			$conexion->close();
			$sentencia1->close();
			$sentencia2->close();
			return array('contar'=>$arr1,'contar_us'=>$arr2);
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	public function contarEstaProv(){
		try{
			$conexion = Conectar::con();
			$arr1 = array();
			$arr2 = array();
			$i=0;
			
			$sql1="SELECT COUNT(*) as total FROM pagos_serv;";
			$sql2="SELECT COUNT(b.id) as total,a.nombre,a.apepat  FROM usuarios as a LEFT JOIN pagos_serv as b ON b.id_us_crea=a.id WHERE a.id<>1 GROUP BY a.id;";
			
			
			$sentencia1 = $conexion->prepare($sql1);
			$sentencia1->execute();
			$sentencia1->bind_result($contar);
			while ($sentencia1->fetch()) {	
				$arr1['contar']=$contar;	
			}
			
			$sentencia2 = $conexion->prepare($sql2);
			$sentencia2->execute();
			$sentencia2->bind_result($total,$nombre,$apepat);
			while ($sentencia2->fetch()) {	
				$arr2[$i]['total']=$total;
				$arr2[$i]['nombre']=$nombre;
				$arr2[$i]['apepat']=$apepat;
				$i++;
			}

			$conexion->close();
			$sentencia1->close();
			$sentencia2->close();
			return array('contar'=>$arr1,'contar_us'=>$arr2);
		
		}catch(Exception $e){
            echo $e;
            Conectar::con()->close();
            return false;
        }
	
	}
	
	
}


function mesnombre($mes){
		$nombre_mes='';
		switch($mes) {
			case 1:
			$nombre_mes='Enero';
			break;
			case 2:
			$nombre_mes='Febrero';
			break;
			case 3:
			$nombre_mes='Marzo';
			break;
			case 4:
			$nombre_mes='Abril';
			break;
			case 5:
			$nombre_mes='Mayo';
			break;
			case 6:
			$nombre_mes='Junio';
			break;
			case 7:
			$nombre_mes='Julio';
			break;
			case 8:
			$nombre_mes='Agosto';
			break;
			case 9:
			$nombre_mes='Septiembre';
			break;
			case 10:
			$nombre_mes='Octubre';
			break;
			case 11:
			$nombre_mes='Noviembre';
			break;
			case 12:
			$nombre_mes='Diciembre';
			break;
		}
		
		return $nombre_mes;
	}
	
	
	function imgNom($prefijo,$img){
	switch($img['type']) {
		case "image/jpg":
		case "image/jpeg":
		$ext = "jpg";
		break; 
		case "image/gif":
		$ext = "gif";
		break; 
		case "image/png":
		$ext = "png";
		break; 
		}			
		$nombre=$prefijo.date("Ymdhis").".".$ext;
		return $nombre;
	}

?>